/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.util.Iterator;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenIndex;
import org.openl.types.impl.AAggregateInfo;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.impl.ArrayFieldIndex;
import org.openl.types.impl.ArrayIndex;
import org.openl.types.impl.ArrayOpenClass;
import org.openl.types.impl.ComponentTypeArrayOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.IntegerValuesUtils;
import org.openl.util.OpenIterator;

public class DynamicArrayAggregateInfo
extends AAggregateInfo {
    public static final DynamicArrayAggregateInfo aggregateInfo = new DynamicArrayAggregateInfo();

    @Override
    public IOpenClass getComponentType(IOpenClass aggregateType) {
        if (aggregateType instanceof ArrayOpenClass) {
            return aggregateType.getComponentClass();
        }
        return null;
    }

    @Override
    public IOpenIndex getIndex(IOpenClass aggregateType, IOpenClass indexType) {
        if (indexType == JavaOpenClass.INT || indexType.getInstanceClass() == Integer.class) {
            return new ArrayIndex(this.getComponentType(aggregateType));
        }
        IOpenClass componentClass = aggregateType.getComponentClass();
        IOpenField indexField = componentClass.getIndexField();
        if (indexField != null) {
            if (indexField.getType() == indexType) {
                return new ArrayFieldIndex(componentClass, indexField);
            }
            if (IntegerValuesUtils.isIntegerValue(indexField.getType().getInstanceClass()) && String.class.equals(indexType.getInstanceClass())) {
                return new ArrayFieldIndex(componentClass, indexField);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOpenClass getIndexedAggregateType(IOpenClass componentType, int dim) {
        IOpenClass[] arrayTypes;
        if (dim == 0) {
            return componentType;
        }
        if (componentType instanceof ComponentTypeArrayOpenClass) {
            return this.getIndexedAggregateType(componentType.getComponentClass(), dim + 1);
        }
        IOpenClass[] iOpenClassArray = arrayTypes = ((ADynamicClass)componentType).getArrayTypes();
        synchronized (arrayTypes) {
            if (arrayTypes[dim - 1] != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return arrayTypes[dim - 1];
            }
            for (int i = 0; i < arrayTypes.length; ++i) {
                arrayTypes[i] = componentType = new ComponentTypeArrayOpenClass(componentType);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return arrayTypes[dim - 1];
        }
    }

    @Override
    public Iterator<Object> getIterator(Object aggregate) {
        return OpenIterator.fromArrayObj((Object)aggregate);
    }

    @Override
    public boolean isAggregate(IOpenClass type) {
        return type instanceof ArrayOpenClass;
    }
}

