/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import org.openl.binding.MethodUtil;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.util.text.ILocation;

public class OpenMethodHeader
implements IOpenMethodHeader {
    protected IMethodSignature signature;
    protected IOpenClass declaringClass;
    protected IOpenClass typeClass;
    protected String name;
    protected boolean isStatic;
    protected IMemberMetaInfo info;
    protected ILocation typeLocation;
    protected ILocation[] paramTypeLocations;

    public OpenMethodHeader(String name, IOpenClass typeClass, IMethodSignature signature, IOpenClass declaringClass, ILocation typeLocation, ILocation[] paramTypeLocations) {
        this(name, typeClass, signature, declaringClass);
        this.typeLocation = typeLocation;
        this.paramTypeLocations = paramTypeLocations;
    }

    public OpenMethodHeader(String name, IOpenClass typeClass, IMethodSignature signature, IOpenClass declaringClass) {
        this(name, typeClass, signature, declaringClass, false, null);
    }

    public OpenMethodHeader(String name, IOpenClass typeClass, IMethodSignature signature, IOpenClass declaringClass, boolean isStatic, IMemberMetaInfo info) {
        this.name = name;
        this.typeClass = typeClass;
        this.signature = signature;
        this.declaringClass = declaringClass;
        this.isStatic = isStatic;
        this.info = info;
    }

    @Override
    public IOpenClass getDeclaringClass() {
        return this.declaringClass;
    }

    public String getDisplayName(int mode) {
        return MethodUtil.printSignature(this, mode);
    }

    @Override
    public IMemberMetaInfo getInfo() {
        return this.info;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public IMethodSignature getSignature() {
        return this.signature;
    }

    @Override
    public IOpenClass getType() {
        return this.typeClass;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    public void setDeclaringClass(IOpenClass declaringClass) {
        this.declaringClass = declaringClass;
    }

    public void setTypeClass(IOpenClass typeClass) {
        this.typeClass = typeClass;
    }

    public ILocation getTypeLocation() {
        return this.typeLocation;
    }

    public ILocation[] getParamTypeLocations() {
        return this.paramTypeLocations;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        buf.append(this.getType().getName()).append(' ');
        MethodUtil.printMethod(this, buf);
        return buf.toString();
    }
}

