/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import org.openl.OpenL;
import org.openl.binding.impl.Binder;
import org.openl.binding.impl.BindingContext;
import org.openl.engine.OpenLManager;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.types.IMethodCaller;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

public class SourceCodeMethodCaller
implements IMethodCaller {
    IOpenMethod method;
    String sourceCode;
    IMethodSignature signature;
    IOpenClass resultType;

    public SourceCodeMethodCaller(IMethodSignature signature, IOpenClass resultType, String sourceCode) {
        if (signature == null) {
            throw new IllegalArgumentException("signature can't be null!");
        }
        if (sourceCode == null) {
            throw new IllegalArgumentException("sourceCode can't be null!");
        }
        this.signature = signature;
        this.sourceCode = sourceCode;
        this.resultType = resultType;
    }

    @Override
    public IOpenMethod getMethod() {
        if (this.method == null) {
            StringSourceCodeModule src = new StringSourceCodeModule(this.sourceCode, null);
            OpenL op = OpenL.getInstance("org.openl.j");
            IOpenClass returnType = this.resultType;
            if (returnType == null) {
                returnType = JavaOpenClass.VOID;
            }
            OpenMethodHeader methodHeader = new OpenMethodHeader("run", this.resultType, this.signature, null);
            BindingContext cxt = new BindingContext((Binder)op.getBinder(), null, op);
            this.method = OpenLManager.makeMethod(op, src, methodHeader, cxt);
        }
        return this.method;
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        return this.getMethod().invoke(null, params, env);
    }
}

