/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ArrayTool;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.vm.IRuntimeEnv;

public class BeanOpenField
implements IOpenField {
    PropertyDescriptor descriptor;
    Method readMethod;
    Method writeMethod;

    public static void collectFields(Map<String, IOpenField> map, Class<?> c, Map<Method, BeanOpenField> getters, Map<Method, BeanOpenField> setters) {
        if (c.isInterface()) {
            Class<?>[] interfaces = c.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                BeanOpenField.collectFields(map, interfaces[i], getters, setters);
            }
        }
        try {
            PropertyDescriptor[] pds;
            BeanInfo info = Introspector.getBeanInfo(c);
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                if (pd.getPropertyType() == null || pd.getName().equals("class")) continue;
                String fieldName = pd.getName();
                Field field = null;
                try {
                    field = c.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException ex) {
                    try {
                        String fname = StringUtils.capitalize((String)fieldName);
                        if (fname.equals(fieldName)) {
                            fname = StringUtils.uncapitalize((String)fieldName);
                        }
                        field = c.getDeclaredField(fname);
                        fieldName = field.getName();
                        pd.setName(fieldName);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
                BeanOpenField bf = new BeanOpenField(pd);
                if (field != null && Modifier.isStatic(field.getModifiers())) continue;
                map.put(fieldName, bf);
                if (getters != null && pd.getReadMethod() != null) {
                    getters.put(pd.getReadMethod(), bf);
                }
                if (setters == null || pd.getWriteMethod() == null) continue;
                setters.put(pd.getWriteMethod(), bf);
            }
        }
        catch (Throwable t) {
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
    }

    private BeanOpenField(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
        this.readMethod = descriptor.getReadMethod();
        this.writeMethod = descriptor.getWriteMethod();
    }

    @Override
    public Object get(Object target, IRuntimeEnv env) {
        try {
            if (target == null) {
                return null;
            }
            return this.readMethod.invoke(target, ArrayTool.ZERO_OBJECT);
        }
        catch (Exception ex) {
            throw RuntimeExceptionWrapper.wrap((String)"", (Throwable)ex);
        }
    }

    @Override
    public IOpenClass getDeclaringClass() {
        if (this.descriptor.getReadMethod() != null) {
            return JavaOpenClass.getOpenClass(this.readMethod.getDeclaringClass());
        }
        if (this.descriptor.getWriteMethod() != null) {
            return JavaOpenClass.getOpenClass(this.writeMethod.getDeclaringClass());
        }
        throw new RuntimeException("Something is wrong with this bean");
    }

    public String getDisplayName(int mode) {
        return this.getName();
    }

    @Override
    public IMemberMetaInfo getInfo() {
        return null;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public IOpenClass getType() {
        return JavaOpenClass.getOpenClass(this.descriptor.getPropertyType());
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return this.readMethod != null;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return this.writeMethod != null;
    }

    @Override
    public void set(Object target, Object value, IRuntimeEnv env) {
        try {
            this.writeMethod.invoke(target, value);
        }
        catch (Exception ex) {
            throw RuntimeExceptionWrapper.wrap((String)"", (Throwable)ex);
        }
    }

    public String toString() {
        return this.getName();
    }
}

