/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenIndex;
import org.openl.types.java.JavaOpenClass;

public class JavaCollectionAggregateInfo
implements IAggregateInfo {
    static final IAggregateInfo COLLECTION_AGGREGATE = new JavaCollectionAggregateInfo();

    @Override
    public IOpenClass getComponentType(IOpenClass aggregateType) {
        return JavaOpenClass.OBJECT;
    }

    @Override
    public IOpenIndex getIndex(IOpenClass aggregateType) {
        return this.getIndex(aggregateType, JavaOpenClass.OBJECT);
    }

    @Override
    public IOpenIndex getIndex(IOpenClass aggregateType, IOpenClass indexType) {
        return new CollectionIndex();
    }

    @Override
    public IOpenClass getIndexedAggregateType(IOpenClass componentType, int dims) {
        return JavaOpenClass.getOpenClass(Collection.class);
    }

    @Override
    public Iterator<Object> getIterator(Object aggregate) {
        return ((Collection)aggregate).iterator();
    }

    @Override
    public boolean isAggregate(IOpenClass type) {
        return Collection.class.isAssignableFrom(type.getInstanceClass());
    }

    @Override
    public Object makeIndexedAggregate(IOpenClass componentType, int[] dimValues) {
        return new HashSet();
    }

    private static class CollectionIndex
    implements IOpenIndex {
        private CollectionIndex() {
        }

        @Override
        public IOpenClass getElementType() {
            return JavaOpenClass.OBJECT;
        }

        @Override
        public IOpenClass getIndexType() {
            return null;
        }

        @Override
        public Collection getIndexes(Object container) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue(Object container, Object index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public void setValue(Object container, Object index, Object value) {
            ((Collection)container).add(value);
        }
    }
}

