/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.util.Iterator;
import org.openl.domain.FixedSizeDomain;
import org.openl.domain.IType;
import org.openl.types.java.JavaOpenEnum;
import org.openl.util.OpenIterator;

public class JavaEnumDomain
extends FixedSizeDomain<Object> {
    private JavaOpenEnum enumClass;

    public JavaEnumDomain(JavaOpenEnum enumClass) {
        this.enumClass = enumClass;
    }

    public Iterator iterator() {
        return OpenIterator.fromArray((Object[])this.enumClass.getInstanceClass().getEnumConstants());
    }

    public int size() {
        return this.enumClass.getInstanceClass().getEnumConstants().length;
    }

    public IType getElementType() {
        return this.enumClass;
    }

    public boolean selectObject(Object obj) {
        return this.enumClass.getInstanceClass().isInstance(obj);
    }

    public boolean selectType(IType type) {
        return type == this.enumClass;
    }

    public Object getValue(int index) {
        return this.enumClass.getInstanceClass().getEnumConstants()[index];
    }

    public JavaOpenEnum getEnumClass() {
        return this.enumClass;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator itr = this.iterator();
        boolean f = false;
        while (itr.hasNext()) {
            Object v = itr.next();
            if (f) {
                sb.append(", ");
            } else {
                f = true;
            }
            sb.append(v.toString());
        }
        return "[" + sb.toString() + "]";
    }
}

