/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openl.binding.exception.AmbiguousTypeException;
import org.openl.conf.ClassFactory;
import org.openl.types.IOpenClass;
import org.openl.types.ITypeLibrary;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.Log;
import org.openl.util.RuntimeExceptionWrapper;

public class JavaImportTypeLibrary
implements ITypeLibrary {
    private Map<String, IOpenClass> aliases = new HashMap<String, IOpenClass>();
    private Set<String> notFound = new HashSet<String>();
    private String[] importPackages;
    private ClassLoader loader;

    public JavaImportTypeLibrary(String[] importPackages, String[] importClasses, ClassLoader loader) {
        this.loader = loader;
        this.importPackages = importPackages == null ? new String[0] : importPackages;
        if (importClasses != null) {
            for (String importClass : importClasses) {
                int index = importClass.lastIndexOf(46);
                String alias = importClass.substring(index + 1);
                try {
                    Class<?> c = ClassFactory.forName(importClass, loader);
                    this.aliases.put(alias, JavaOpenClass.getOpenClass(c));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected ClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public synchronized IOpenClass getType(String typename) throws AmbiguousTypeException {
        IOpenClass oc = this.aliases.get(typename);
        if (oc != null) {
            return oc;
        }
        if (this.notFound.contains(typename)) {
            return null;
        }
        for (String singleImport : this.importPackages) {
            String name = singleImport + "." + typename;
            try {
                Class<?> c = this.getClassLoader().loadClass(name);
                oc = JavaOpenClass.getOpenClass(c);
                this.aliases.put(typename, oc);
                return oc;
            }
            catch (ClassNotFoundException c) {
            }
            catch (NoClassDefFoundError e) {
                if (!(e.getCause() instanceof ClassNotFoundException)) continue;
                String noClassMessage = e.getCause().getMessage();
                String message = String.format("Can't load type '%s' because of absent type '%s'.", name, noClassMessage);
                throw RuntimeExceptionWrapper.wrap((String)message, (Throwable)e);
            }
            catch (UnsupportedClassVersionError e) {
                String message = String.format("Can't load the class '%s' that was compiled using newer version of JDK than current JRE (%s)", name, System.getProperty("java.version"));
                throw RuntimeExceptionWrapper.wrap((String)message, (Throwable)e);
            }
            catch (Throwable t) {
                Log.error((Object)("Can't load class: " + name), (Throwable)t);
                throw RuntimeExceptionWrapper.wrap((Throwable)t);
            }
        }
        this.notFound.add(typename);
        return null;
    }
}

