/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenIndex;
import org.openl.types.impl.AAggregateInfo;
import org.openl.types.java.JavaOpenClass;

public class JavaListAggregateInfo
extends AAggregateInfo {
    public static final IAggregateInfo LIST_AGGREGATE = new JavaListAggregateInfo();

    @Override
    public IOpenClass getComponentType(IOpenClass aggregateType) {
        return JavaOpenClass.OBJECT;
    }

    @Override
    public IOpenIndex getIndex(IOpenClass aggregateType, IOpenClass indexType) {
        if (indexType != JavaOpenClass.INT && indexType.getInstanceClass() != Integer.class) {
            return null;
        }
        if (!this.isAggregate(aggregateType)) {
            return null;
        }
        return this.makeListIndex(aggregateType);
    }

    @Override
    public Iterator<Object> getIterator(Object aggregate) {
        return ((Collection)aggregate).iterator();
    }

    @Override
    public boolean isAggregate(IOpenClass type) {
        return List.class.isAssignableFrom(type.getInstanceClass());
    }

    @Override
    public Object makeIndexedAggregate(IOpenClass componentClass, int[] dimValues) {
        if (dimValues.length > 1) {
            throw new UnsupportedOperationException("Only one dimensional Java Lists are supported.");
        }
        int size = dimValues[0];
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(null);
        }
        return list;
    }

    @Override
    public IOpenClass getIndexedAggregateType(IOpenClass componentType, int dim) {
        return JavaOpenClass.getOpenClass(List.class);
    }

    private IOpenIndex makeListIndex(IOpenClass aggregateType) {
        return new ListIndex();
    }

    static class ListIndex
    implements IOpenIndex {
        ListIndex() {
        }

        @Override
        public IOpenClass getElementType() {
            return JavaOpenClass.OBJECT;
        }

        @Override
        public IOpenClass getIndexType() {
            return JavaOpenClass.INT;
        }

        @Override
        public Collection getIndexes(Object container) {
            int length = ((List)container).size();
            ArrayList<Integer> indexes = new ArrayList<Integer>(length);
            for (int i = 0; i < length; ++i) {
                indexes.add(i);
            }
            return indexes;
        }

        @Override
        public Object getValue(Object container, Object index) {
            if (container == null || index == null) {
                return null;
            }
            return ((List)container).get((Integer)index);
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public void setValue(Object container, Object index, Object value) {
            ((List)container).set((Integer)index, value);
        }
    }
}

