/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenIndex;
import org.openl.types.java.JavaOpenClass;

public class JavaMapAggregateInfo
implements IAggregateInfo {
    static final IAggregateInfo MAP_AGGREGATE = new JavaMapAggregateInfo();

    @Override
    public IOpenClass getComponentType(IOpenClass aggregateType) {
        return JavaOpenClass.getOpenClass(Map.Entry.class);
    }

    @Override
    public IOpenIndex getIndex(IOpenClass aggregateType) {
        return this.getIndex(aggregateType, JavaOpenClass.OBJECT);
    }

    @Override
    public IOpenIndex getIndex(IOpenClass aggregateType, IOpenClass indexType) {
        if (!this.isAggregate(aggregateType)) {
            return null;
        }
        return new MapIndex();
    }

    @Override
    public Iterator<Object> getIterator(Object aggregate) {
        return ((Map)aggregate).entrySet().iterator();
    }

    @Override
    public boolean isAggregate(IOpenClass type) {
        return Map.class.isAssignableFrom(type.getInstanceClass());
    }

    @Override
    public IOpenClass getIndexedAggregateType(IOpenClass componentType, int dims) {
        return JavaOpenClass.getOpenClass(Map.class);
    }

    @Override
    public Object makeIndexedAggregate(IOpenClass componentType, int[] dimValues) {
        if (dimValues.length > 1) {
            throw new UnsupportedOperationException("Only one dimensional Java Maps are supported.");
        }
        return new HashMap(dimValues[0]);
    }

    static class MapIndex
    implements IOpenIndex {
        MapIndex() {
        }

        @Override
        public IOpenClass getElementType() {
            return JavaOpenClass.OBJECT;
        }

        @Override
        public IOpenClass getIndexType() {
            return JavaOpenClass.OBJECT;
        }

        @Override
        public Collection getIndexes(Object container) {
            return ((Map)container).keySet();
        }

        @Override
        public Object getValue(Object container, Object index) {
            return container == null ? null : ((Map)container).get(index);
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        @Override
        public void setValue(Object container, Object index, Object value) {
            ((Map)container).put(index, value);
        }
    }
}

