/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openl.classloader.OpenLBundleClassLoader;
import org.openl.types.IAggregateInfo;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.AOpenClass;
import org.openl.types.impl.ArrayIndex;
import org.openl.types.impl.ArrayLengthOpenField;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.BeanOpenField;
import org.openl.types.java.CustomJavaOpenClass;
import org.openl.types.java.JavaArrayAggregateInfo;
import org.openl.types.java.JavaCollectionAggregateInfo;
import org.openl.types.java.JavaListAggregateInfo;
import org.openl.types.java.JavaMapAggregateInfo;
import org.openl.types.java.JavaOpenClassCache;
import org.openl.types.java.JavaOpenConstructor;
import org.openl.types.java.JavaOpenEnum;
import org.openl.types.java.JavaOpenField;
import org.openl.types.java.JavaOpenMethod;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.StringTool;
import org.openl.vm.IRuntimeEnv;

public class JavaOpenClass
extends AOpenClass {
    public static final JavaOpenClass INT = new JavaPrimitiveClass(Integer.TYPE, Integer.class, 0);
    public static final JavaOpenClass LONG = new JavaPrimitiveClass(Long.TYPE, Long.class, 0L);
    public static final JavaOpenClass DOUBLE = new JavaPrimitiveClass(Double.TYPE, Double.class, 0.0);
    public static final JavaOpenClass FLOAT = new JavaPrimitiveClass(Float.TYPE, Float.class, Float.valueOf(0.0f));
    public static final JavaOpenClass SHORT = new JavaPrimitiveClass(Short.TYPE, Short.class, (short)0);
    public static final JavaOpenClass CHAR = new JavaPrimitiveClass(Character.TYPE, Character.class, Character.valueOf('\u0000'));
    public static final JavaOpenClass BYTE = new JavaPrimitiveClass(Byte.TYPE, Byte.class, (byte)0);
    public static final JavaOpenClass BOOLEAN = new JavaPrimitiveClass(Boolean.TYPE, Boolean.class, Boolean.FALSE);
    public static final JavaOpenClass VOID = new JavaPrimitiveClass(Void.TYPE, Void.class, null);
    public static final JavaOpenClass STRING = new JavaOpenClass(String.class, true);
    public static final JavaOpenClass OBJECT = new JavaOpenClass(Object.class, false);
    public static final JavaOpenClass CLASS = new JavaOpenClass(Class.class, true);
    protected Class<?> instanceClass;
    private final boolean simple;
    private IAggregateInfo aggregateInfo;
    protected volatile Map<String, IOpenField> fields;
    String name;
    List<IOpenClass> superClasses;

    protected JavaOpenClass(Class<?> instanceClass) {
        this(instanceClass, false);
    }

    protected JavaOpenClass(Class<?> instanceClass, boolean simple) {
        this.instanceClass = instanceClass;
        this.simple = simple;
    }

    public static JavaOpenClass getOpenClass(Class<?> c) {
        JavaOpenClass res = JavaOpenClassCache.getInstance().get(c);
        if (res == null) {
            CustomJavaOpenClass annotation;
            res = c.isInterface() ? new JavaOpenInterface(c) : (c.isEnum() ? new JavaOpenEnum(c) : ((annotation = c.getAnnotation(CustomJavaOpenClass.class)) != null ? JavaOpenClass.createOpenClass(c, annotation) : new JavaOpenClass(c)));
            JavaOpenClassCache.getInstance().put(c, res);
        }
        return res;
    }

    public static JavaOpenClass createNewOpenClass(Class<?> c) {
        if (c.isInterface()) {
            return new JavaOpenInterface(c);
        }
        if (c.isEnum()) {
            return new JavaOpenEnum(c);
        }
        return new JavaOpenClass(c);
    }

    private static JavaOpenClass createOpenClass(Class<?> c, CustomJavaOpenClass annotation) {
        Class<? extends JavaOpenClass> type = annotation.type();
        try {
            return type.getConstructor(Class.class).newInstance(c);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(String.format("Cannot find constructor with signature 'public MyCustomJavaOpenClass(Class<?> c)' in type %s", type.getCanonicalName()), e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(String.format("Error while creating a custom JavaOpenClass of type '%s'", type.getCanonicalName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Constructor of a custom JavaOpenClass of type '%s' is inaccessible", type.getCanonicalName()), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(String.format("Constructor of a class '%s' threw and exception", type.getCanonicalName()), e);
        }
    }

    public static IOpenClass[] getOpenClasses(Class<?>[] cc) {
        if (cc.length == 0) {
            return IOpenClass.EMPTY;
        }
        IOpenClass[] ary = new IOpenClass[cc.length];
        for (int i = 0; i < cc.length; ++i) {
            ary[i] = JavaOpenClass.getOpenClass(cc[i]);
        }
        return ary;
    }

    public static Class<?> makeArrayClass(Class<?> c) {
        return Array.newInstance(c, 0).getClass();
    }

    public static ArrayIndex makeArrayIndex(IOpenClass arrayType) {
        return new ArrayIndex(JavaOpenClass.getOpenClass(arrayType.getInstanceClass().getComponentType()));
    }

    public static synchronized void resetClassloader(ClassLoader cl) {
        ArrayList toRemove = new ArrayList();
        Collection<Class<?>> nonJavaClasses = JavaOpenClassCache.getInstance().getNonJavaClasses();
        for (Class<Object> c : nonJavaClasses) {
            ClassLoader classLoader = c.getClassLoader();
            if (classLoader == cl) {
                toRemove.add(c);
            }
            if (!(cl instanceof OpenLBundleClassLoader) || !((OpenLBundleClassLoader)cl).containsClassLoader(classLoader)) continue;
            toRemove.add(c);
        }
        for (Class<Object> c : toRemove) {
            JavaOpenClassCache.getInstance().remove(c);
        }
    }

    public static boolean isVoid(IOpenClass clazz) {
        return VOID.equals(clazz);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JavaOpenClass)) {
            return false;
        }
        return this.instanceClass == ((JavaOpenClass)obj).instanceClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, IOpenField> fieldMap() {
        if (this.fields == null) {
            JavaOpenClass javaOpenClass = this;
            synchronized (javaOpenClass) {
                if (this.fields == null) {
                    this.fields = this.initalizeFields();
                }
            }
        }
        return this.fields;
    }

    private Map<String, IOpenField> initalizeFields() {
        HashMap<String, IOpenField> fields = new HashMap<String, IOpenField>();
        Field[] ff = this.instanceClass.getDeclaredFields();
        if (this.isPublic(this.instanceClass)) {
            for (int i = 0; i < ff.length; ++i) {
                if (!this.isPublic(ff[i])) continue;
                fields.put(ff[i].getName(), new JavaOpenField(ff[i]));
            }
        }
        if (this.instanceClass.isArray()) {
            fields.put("length", new JavaArrayLengthField());
        }
        fields.put("class", new JavaClassClassField(this.instanceClass));
        BeanOpenField.collectFields(fields, this.instanceClass, this.getGetters(), this.getSetters());
        return fields;
    }

    protected Map<Method, BeanOpenField> getGetters() {
        return null;
    }

    protected Map<Method, BeanOpenField> getSetters() {
        return null;
    }

    @Override
    public synchronized IAggregateInfo getAggregateInfo() {
        if (this.aggregateInfo != null) {
            return this.aggregateInfo;
        }
        Class<?> instanceClass = this.getInstanceClass();
        this.aggregateInfo = List.class.isAssignableFrom(instanceClass) ? JavaListAggregateInfo.LIST_AGGREGATE : (Map.class.isAssignableFrom(instanceClass) ? JavaMapAggregateInfo.MAP_AGGREGATE : (Collection.class.isAssignableFrom(instanceClass) ? JavaCollectionAggregateInfo.COLLECTION_AGGREGATE : JavaArrayAggregateInfo.ARRAY_AGGREGATE));
        return this.aggregateInfo;
    }

    public String getDisplayName(int mode) {
        String name = this.getName();
        switch (mode) {
            default: {
                return StringTool.lastToken((String)name, (String)".");
            }
            case 2: 
        }
        return name;
    }

    @Override
    public Class<?> getInstanceClass() {
        return this.instanceClass;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.instanceClass.getCanonicalName();
        }
        return this.name;
    }

    @Override
    public String getJavaName() {
        return this.instanceClass.getName();
    }

    public String getSimpleName() {
        return this.getDisplayName(0);
    }

    @Override
    public int hashCode() {
        return this.instanceClass.hashCode();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.instanceClass.getModifiers());
    }

    @Override
    public boolean isAssignableFrom(Class<?> c) {
        return this.instanceClass.isAssignableFrom(c);
    }

    @Override
    public boolean isAssignableFrom(IOpenClass ioc) {
        return this.instanceClass.isAssignableFrom(ioc.getInstanceClass());
    }

    @Override
    public boolean isInstance(Object instance) {
        return this.instanceClass.isInstance(instance);
    }

    protected boolean isPublic(Class<?> declaringClass) {
        return Modifier.isPublic(declaringClass.getModifiers());
    }

    protected boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    @Override
    public boolean isSimple() {
        return this.simple;
    }

    @Override
    protected Map<MethodKey, IOpenMethod> initMethodMap() {
        HashMap<MethodKey, JavaOpenMethod> methods = new HashMap<MethodKey, JavaOpenMethod>();
        Method[] mm = this.instanceClass.getDeclaredMethods();
        if (this.isPublic(this.instanceClass)) {
            for (int i = 0; i < mm.length; ++i) {
                if (!this.isPublic(mm[i])) continue;
                JavaOpenMethod om = new JavaOpenMethod(mm[i]);
                methods.put(new MethodKey(om), om);
            }
        }
        if (methods.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(methods);
    }

    @Override
    protected Map<MethodKey, IOpenMethod> initConstructorMap() {
        HashMap<MethodKey, JavaOpenConstructor> constructors = new HashMap<MethodKey, JavaOpenConstructor>();
        Constructor<?>[] cc = this.instanceClass.getDeclaredConstructors();
        for (int i = 0; i < cc.length; ++i) {
            if (!this.isPublic(cc[i])) continue;
            JavaOpenConstructor om = new JavaOpenConstructor(cc[i]);
            constructors.put(new MethodKey(om), om);
        }
        if (constructors.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(constructors);
    }

    @Override
    public Object newInstance(IRuntimeEnv env) {
        try {
            return this.getInstanceClass().newInstance();
        }
        catch (Exception e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
    }

    @Override
    public Object nullObject() {
        return null;
    }

    @Override
    public IOpenClass getComponentClass() {
        return this.getAggregateInfo().getComponentType(this);
    }

    @Override
    public synchronized Iterable<IOpenClass> superClasses() {
        if (this.superClasses == null) {
            Class<?>[] interfaces = this.instanceClass.getInterfaces();
            Class<?> superClass = this.instanceClass.getSuperclass();
            ArrayList<IOpenClass> superClasses = new ArrayList<IOpenClass>(interfaces.length + 1);
            if (superClass != null) {
                superClasses.add(JavaOpenClass.getOpenClass(superClass));
            }
            for (Class<?> interf : interfaces) {
                superClasses.add(JavaOpenClass.getOpenClass(interf));
            }
            this.superClasses = superClasses;
        }
        return this.superClasses;
    }

    private static class JavaOpenInterface
    extends JavaOpenClass {
        private static Method toString;
        private static Method equals;
        private static Method hashCode;
        private Map<Method, BeanOpenField> getters = new HashMap<Method, BeanOpenField>();
        private Map<Method, BeanOpenField> setters = new HashMap<Method, BeanOpenField>();
        private Class<?> proxyClass;
        private InvocationHandler beanInterfaceHandler;

        protected JavaOpenInterface(Class<?> instanceClass) {
            super(instanceClass);
            this.proxyClass = Proxy.getProxyClass(instanceClass.getClassLoader(), instanceClass);
        }

        @Override
        protected Map<Method, BeanOpenField> getGetters() {
            return this.getters;
        }

        @Override
        protected Map<Method, BeanOpenField> getSetters() {
            return this.setters;
        }

        private synchronized InvocationHandler getInvocationHandler(Class<?> instClass) {
            if (List.class.isAssignableFrom(instClass)) {
                return new JavaInstanceBasedInvocationhandler(new ArrayList());
            }
            if (Set.class.isAssignableFrom(instClass)) {
                return new JavaInstanceBasedInvocationhandler(new HashSet());
            }
            if (SortedMap.class.isAssignableFrom(instClass)) {
                return new JavaInstanceBasedInvocationhandler(new TreeMap());
            }
            if (Map.class.isAssignableFrom(instClass)) {
                return new JavaInstanceBasedInvocationhandler(new HashMap());
            }
            if (Collection.class.isAssignableFrom(instClass)) {
                return new JavaInstanceBasedInvocationhandler(new ArrayList());
            }
            if (this.beanInterfaceHandler == null) {
                this.beanInterfaceHandler = new BeanInterfaceInvocationHandler();
            }
            return this.beanInterfaceHandler;
        }

        @Override
        public Object newInstance(IRuntimeEnv env) {
            try {
                return Proxy.newProxyInstance(this.instanceClass.getClassLoader(), new Class[]{this.instanceClass}, this.getInvocationHandler(this.instanceClass));
            }
            catch (Exception e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }

        static {
            try {
                toString = Object.class.getMethod("toString", new Class[0]);
                equals = Object.class.getMethod("equals", Object.class);
                hashCode = Object.class.getMethod("hashCode", new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw RuntimeExceptionWrapper.wrap((Throwable)nsme);
            }
        }

        private class BeanInterfaceInvocationHandler
        implements InvocationHandler {
            private IdentityHashMap<Object, HashMap<BeanOpenField, Object>> map = new IdentityHashMap();

            private BeanInterfaceInvocationHandler() {
            }

            @Override
            public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                HashMap<BeanOpenField, Object> values = this.map.get(proxy);
                if (values == null) {
                    values = new HashMap();
                    this.map.put(proxy, values);
                }
                BeanOpenField bf = null;
                if (JavaOpenInterface.this.getters != null) {
                    bf = (BeanOpenField)JavaOpenInterface.this.getters.get(method);
                }
                if (bf != null) {
                    Object res = values.get(bf);
                    return res != null ? res : bf.getType().nullObject();
                }
                if (JavaOpenInterface.this.setters != null) {
                    bf = (BeanOpenField)JavaOpenInterface.this.setters.get(method);
                }
                if (bf != null) {
                    values.put(bf, args[0]);
                    return null;
                }
                if (method.getName().equals(toString.getName())) {
                    return proxy.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
                }
                if (method.getName().equals(hashCode.getName())) {
                    return System.identityHashCode(proxy);
                }
                if (method.getName().equals(equals.getName())) {
                    return proxy == args[0];
                }
                throw new RuntimeException("Default Interface Proxy Implementation does not support method " + method.getDeclaringClass().getName() + "::" + method.getName() + ". Only bean access is supported");
            }
        }

        private class JavaInstanceBasedInvocationhandler
        implements InvocationHandler {
            Object instance;

            public JavaInstanceBasedInvocationhandler(Object instance) {
                this.instance = instance;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke(this.instance, args);
            }
        }
    }

    private static class JavaPrimitiveClass
    extends JavaOpenClass {
        private Class<?> wrapperClass;
        private Object nullObject;

        public JavaPrimitiveClass(Class<?> instanceClass, Class<?> wrapperClass, Object nullObject) {
            super(instanceClass, true);
            this.wrapperClass = wrapperClass;
            this.nullObject = nullObject;
        }

        @Override
        public Object newInstance(IRuntimeEnv env) {
            return this.nullObject;
        }

        @Override
        public Object nullObject() {
            return this.nullObject;
        }
    }

    private static class JavaClassClassField
    implements IOpenField {
        private Class<?> instanceClass;

        public JavaClassClassField(Class<?> instanceClass) {
            this.instanceClass = instanceClass;
        }

        @Override
        public Object get(Object target, IRuntimeEnv env) {
            return this.instanceClass;
        }

        @Override
        public IOpenClass getDeclaringClass() {
            return null;
        }

        public String getDisplayName(int mode) {
            return "class";
        }

        @Override
        public IMemberMetaInfo getInfo() {
            return null;
        }

        public String getName() {
            return "class";
        }

        @Override
        public IOpenClass getType() {
            return CLASS;
        }

        @Override
        public boolean isConst() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public void set(Object target, Object value, IRuntimeEnv env) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class JavaArrayLengthField
    extends ArrayLengthOpenField {
        private JavaArrayLengthField() {
        }

        @Override
        public int getLength(Object target) {
            if (target == null) {
                return 0;
            }
            return Array.getLength(target);
        }
    }
}

