/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.openl.meta.BigDecimalValue;
import org.openl.meta.BigIntegerValue;
import org.openl.meta.ByteValue;
import org.openl.meta.DoubleValue;
import org.openl.meta.FloatValue;
import org.openl.meta.IntValue;
import org.openl.meta.LongValue;
import org.openl.meta.ShortValue;
import org.openl.meta.StringValue;
import org.openl.types.java.JavaOpenClass;

final class JavaOpenClassCache {
    private volatile Map<Class<?>, JavaOpenClass> javaClassCache;
    private Map<Class<?>, JavaOpenClass> cache = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.SOFT, AbstractReferenceMap.ReferenceStrength.SOFT);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    JavaOpenClassCache() {
    }

    public static JavaOpenClassCache getInstance() {
        return JavaOpenClassCacheHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Class<?>, JavaOpenClass> getJavaClassCache() {
        if (this.javaClassCache == null) {
            JavaOpenClassCache javaOpenClassCache = this;
            synchronized (javaOpenClassCache) {
                if (this.javaClassCache == null) {
                    this.javaClassCache = JavaOpenClassCache.initializeJavaClassCache();
                }
            }
        }
        return this.javaClassCache;
    }

    private static Map<Class<?>, JavaOpenClass> initializeJavaClassCache() {
        HashMap javaClassCache = new HashMap();
        javaClassCache.put(Integer.TYPE, JavaOpenClass.INT);
        javaClassCache.put(Integer.class, new JavaOpenClass(Integer.class, true));
        javaClassCache.put(Long.TYPE, JavaOpenClass.LONG);
        javaClassCache.put(Long.class, new JavaOpenClass(Long.class, true));
        javaClassCache.put(Double.TYPE, JavaOpenClass.DOUBLE);
        javaClassCache.put(Double.class, new JavaOpenClass(Double.class, true));
        javaClassCache.put(Float.TYPE, JavaOpenClass.FLOAT);
        javaClassCache.put(Float.class, new JavaOpenClass(Float.class, true));
        javaClassCache.put(Short.TYPE, JavaOpenClass.SHORT);
        javaClassCache.put(Short.class, new JavaOpenClass(Short.class, true));
        javaClassCache.put(Character.TYPE, JavaOpenClass.CHAR);
        javaClassCache.put(Character.class, new JavaOpenClass(Character.class, true));
        javaClassCache.put(Byte.TYPE, JavaOpenClass.BYTE);
        javaClassCache.put(Byte.class, new JavaOpenClass(Byte.class, true));
        javaClassCache.put(Boolean.TYPE, JavaOpenClass.BOOLEAN);
        javaClassCache.put(Boolean.class, new JavaOpenClass(Boolean.class, true));
        javaClassCache.put(Void.TYPE, JavaOpenClass.VOID);
        javaClassCache.put(String.class, JavaOpenClass.STRING);
        javaClassCache.put(Object.class, JavaOpenClass.OBJECT);
        javaClassCache.put(Class.class, JavaOpenClass.CLASS);
        javaClassCache.put(Date.class, new JavaOpenClass(Date.class, true));
        javaClassCache.put(BigInteger.class, new JavaOpenClass(BigInteger.class, true));
        javaClassCache.put(BigDecimal.class, new JavaOpenClass(BigDecimal.class, true));
        javaClassCache.put(BigDecimalValue.class, new JavaOpenClass(BigDecimalValue.class, true));
        javaClassCache.put(BigIntegerValue.class, new JavaOpenClass(BigIntegerValue.class, true));
        javaClassCache.put(ByteValue.class, new JavaOpenClass(ByteValue.class, true));
        javaClassCache.put(DoubleValue.class, new JavaOpenClass(DoubleValue.class, true));
        javaClassCache.put(FloatValue.class, new JavaOpenClass(FloatValue.class, true));
        javaClassCache.put(IntValue.class, new JavaOpenClass(IntValue.class, true));
        javaClassCache.put(LongValue.class, new JavaOpenClass(LongValue.class, true));
        javaClassCache.put(ShortValue.class, new JavaOpenClass(ShortValue.class, true));
        javaClassCache.put(StringValue.class, new JavaOpenClass(StringValue.class, true));
        return javaClassCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaOpenClass get(Class<?> c) {
        JavaOpenClass openClass = this.getJavaClassCache().get(c);
        if (openClass != null) {
            return openClass;
        }
        Lock lock = this.readWriteLock.readLock();
        try {
            lock.lock();
            JavaOpenClass javaOpenClass = this.cache.get(c);
            return javaOpenClass;
        }
        finally {
            lock.unlock();
        }
    }

    public Collection<Class<?>> getNonJavaClasses() {
        Lock lock = this.readWriteLock.readLock();
        try {
            lock.lock();
            Collection<Class<?>> collection = Collections.unmodifiableCollection(this.cache.keySet());
            return collection;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Class<?> c, JavaOpenClass openClass) {
        if (this.getJavaClassCache().containsKey(c)) {
            return;
        }
        Lock lock = this.readWriteLock.writeLock();
        try {
            lock.lock();
            this.cache.put(c, openClass);
        }
        finally {
            lock.unlock();
        }
    }

    public void remove(Class<?> c) {
        if (this.getJavaClassCache().containsKey(c)) {
            return;
        }
        Lock lock = this.readWriteLock.writeLock();
        try {
            lock.lock();
            this.cache.remove(c);
        }
        finally {
            lock.unlock();
        }
    }

    private static class JavaOpenClassCacheHolder {
        private static final JavaOpenClassCache INSTANCE = new JavaOpenClassCache();

        private JavaOpenClassCacheHolder() {
        }
    }
}

