/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.vm.IRuntimeEnv;

public class JavaOpenField
implements IOpenField {
    Field field;

    JavaOpenField(Field field) {
        this.field = field;
    }

    @Override
    public Object get(Object target, IRuntimeEnv env) {
        try {
            return this.field.get(target);
        }
        catch (Exception t) {
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
    }

    @Override
    public IOpenClass getDeclaringClass() {
        return JavaOpenClass.getOpenClass(this.field.getDeclaringClass());
    }

    public String getDisplayName(int mode) {
        return this.getName();
    }

    @Override
    public IMemberMetaInfo getInfo() {
        return null;
    }

    public String getName() {
        return this.field.getName();
    }

    @Override
    public IOpenClass getType() {
        return JavaOpenClass.getOpenClass(this.field.getType());
    }

    @Override
    public boolean isConst() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public void set(Object target, Object value, IRuntimeEnv env) {
        try {
            this.field.set(target, value);
        }
        catch (Exception t) {
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
    }

    public String toString() {
        return this.getName();
    }

    public Field getJavaField() {
        return this.field;
    }
}

