/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.openl.binding.MethodUtil;
import org.openl.exception.OpenLRuntimeException;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;

public class JavaOpenMethod
implements IOpenMethod,
IMethodSignature {
    Method method;
    IOpenClass[] parameterTypes;

    public JavaOpenMethod(Method method) {
        this.method = method;
    }

    @Override
    public IOpenClass getDeclaringClass() {
        return JavaOpenClass.getOpenClass(this.method.getDeclaringClass());
    }

    public String getDisplayName(int mode) {
        return MethodUtil.printSignature(this, mode);
    }

    @Override
    public IMemberMetaInfo getInfo() {
        return null;
    }

    @Override
    public IOpenMethod getMethod() {
        return this;
    }

    public String getName() {
        return this.method.getName();
    }

    @Override
    public int getNumberOfParameters() {
        return this.getParameterTypes().length;
    }

    @Override
    public String getParameterName(int i) {
        return null;
    }

    @Override
    public IOpenClass getParameterType(int i) {
        return this.getParameterTypes()[i];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOpenClass[] getParameterTypes() {
        if (this.parameterTypes == null) {
            JavaOpenMethod javaOpenMethod = this;
            synchronized (javaOpenMethod) {
                this.parameterTypes = JavaOpenClass.getOpenClasses(this.method.getParameterTypes());
            }
        }
        return this.parameterTypes;
    }

    @Override
    public IMethodSignature getSignature() {
        return this;
    }

    @Override
    public IOpenClass getType() {
        return JavaOpenClass.getOpenClass(this.method.getReturnType());
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        try {
            return this.method.invoke(target, params);
        }
        catch (InvocationTargetException t) {
            String msg = "Failure in the method: " + this.method + " on the target: " + String.valueOf(target) + " with values: [" + StringUtils.join((Object[])params, (String)"], [") + "]. Cause: " + t.getTargetException().getMessage();
            throw new OpenLRuntimeException(msg, t);
        }
        catch (Throwable t) {
            String msg = "Failure in the method: " + this.method + " on the target: " + String.valueOf(target) + " with values: [" + StringUtils.join((Object[])params, (String)"], [") + "]. Cause: " + t.getMessage();
            throw new OpenLRuntimeException(msg, t);
        }
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public Method getJavaMethod() {
        return this.method;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isConstructor() {
        return false;
    }
}

