/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.util.ArrayList;
import java.util.Collection;
import org.openl.types.IOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;

public class OpenClassHelper {
    public static synchronized IOpenClass getOpenClass(IOpenClass moduleOpenClass, Class<?> classToFind) {
        IOpenClass result = null;
        if (classToFind != null) {
            Collection<IOpenClass> internalTypes = moduleOpenClass.getTypes();
            if (classToFind.isArray()) {
                IOpenClass componentType = OpenClassHelper.findType(classToFind.getComponentType(), internalTypes);
                if (componentType != null) {
                    result = componentType.getAggregateInfo().getIndexedAggregateType(componentType, 1);
                }
            } else {
                result = OpenClassHelper.findType(classToFind, internalTypes);
            }
            if (result == null) {
                result = JavaOpenClass.getOpenClass(classToFind);
            }
        }
        return result;
    }

    private static IOpenClass findType(Class<?> classToFind, Iterable<IOpenClass> internalTypes) {
        IOpenClass result = null;
        for (IOpenClass datatypeClass : internalTypes) {
            if (datatypeClass instanceof DomainOpenClass || !classToFind.getName().equals(datatypeClass.getInstanceClass().getName())) continue;
            result = datatypeClass;
            break;
        }
        return result;
    }

    public static synchronized IOpenClass[] getOpenClasses(IOpenClass moduleOpenClass, Class<?>[] classesToFind) {
        if (classesToFind.length == 0) {
            return IOpenClass.EMPTY;
        }
        ArrayList<IOpenClass> openClassList = new ArrayList<IOpenClass>();
        for (Class<?> classToFind : classesToFind) {
            openClassList.add(OpenClassHelper.getOpenClass(moduleOpenClass, classToFind));
        }
        return openClassList.toArray(new IOpenClass[openClassList.size()]);
    }
}

