/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.HashSet;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;

public final class OpenClassUtils {
    private OpenClassUtils() {
    }

    public static IOpenClass findParentClassWithBoxing(IOpenClass openClass1, IOpenClass openClass2) {
        IOpenClass t1 = openClass1;
        IOpenClass t2 = openClass2;
        if (t1.getInstanceClass() != null && t2.getInstanceClass() != null && (t1.getInstanceClass().isPrimitive() && !t2.getInstanceClass().isPrimitive() || !t1.getInstanceClass().isPrimitive() && t2.getInstanceClass().isPrimitive())) {
            if (t1.getInstanceClass().isPrimitive()) {
                t1 = JavaOpenClass.getOpenClass(ClassUtils.primitiveToWrapper(t1.getInstanceClass()));
            }
            if (t2.getInstanceClass().isPrimitive()) {
                t2 = JavaOpenClass.getOpenClass(ClassUtils.primitiveToWrapper(t2.getInstanceClass()));
            }
        }
        return OpenClassUtils.findParentClass(t1, t2);
    }

    public static IOpenClass findParentClass(IOpenClass class1, IOpenClass class2) {
        boolean f;
        Iterable<IOpenClass> itr;
        if (NullOpenClass.isAnyNull(class1)) {
            return class2;
        }
        if (NullOpenClass.isAnyNull(class2)) {
            return class1;
        }
        if (class1.isArray() && class2.isArray()) {
            int dim = 0;
            while (class1.isArray() && class2.isArray()) {
                ++dim;
                class1 = class1.getComponentClass();
                class2 = class2.getComponentClass();
            }
            IOpenClass parentClass = OpenClassUtils.findParentClass(class1, class2);
            if (parentClass == null) {
                return null;
            }
            return parentClass.getArrayType(dim);
        }
        if (class1.getInstanceClass() == null && class2.getInstanceClass() == null) {
            return class1;
        }
        if (class1.getInstanceClass() == null) {
            if (class2.getInstanceClass().isPrimitive()) {
                return null;
            }
            return class2;
        }
        if (class2.getInstanceClass() == null) {
            if (class1.getInstanceClass().isPrimitive()) {
                return null;
            }
            return class1;
        }
        if (class1.getInstanceClass().isPrimitive() || class2.getInstanceClass().isPrimitive()) {
            if (class1.equals(class2)) {
                return class1;
            }
            return null;
        }
        HashSet<IOpenClass> superClasses = new HashSet<IOpenClass>();
        IOpenClass openClass = class1;
        superClasses.add(openClass);
        while (!openClass.equals(JavaOpenClass.OBJECT)) {
            itr = openClass.superClasses();
            f = false;
            for (IOpenClass superClass : itr) {
                if (superClass.getInstanceClass().isInterface()) continue;
                superClasses.add(superClass);
                openClass = superClass;
                f = true;
                break;
            }
            if (f) continue;
            break;
        }
        openClass = class2;
        if (superClasses.contains(class2)) {
            return class2;
        }
        while (!openClass.equals(JavaOpenClass.OBJECT)) {
            itr = openClass.superClasses();
            f = false;
            for (IOpenClass superClass : itr) {
                if (superClass.getInstanceClass().isInterface()) continue;
                if (superClasses.contains(superClass)) {
                    return superClass;
                }
                openClass = superClass;
                f = true;
                break;
            }
            if (f) continue;
            break;
        }
        return null;
    }
}

