/*
 * Decompiled with CFR 0.152.
 */
package org.openl.vm;

import org.openl.IOpenRunner;
import org.openl.IOpenVM;
import org.openl.binding.IBoundMethodNode;
import org.openl.binding.IBoundNode;
import org.openl.exception.OpenLRuntimeException;
import org.openl.runtime.DefaultRuntimeContext;
import org.openl.runtime.IRuntimeContext;
import org.openl.util.fast.FastStack;
import org.openl.vm.IRuntimeEnv;

public class SimpleVM
implements IOpenVM {
    private static final SimpleRunner SIMPLE_RUNNER = new SimpleRunner();

    @Override
    public IOpenRunner getRunner() {
        return SIMPLE_RUNNER;
    }

    @Override
    public IRuntimeEnv getRuntimeEnv() {
        return new SimpleRuntimeEnv();
    }

    public static class SimpleRuntimeEnv
    implements IRuntimeEnv {
        IOpenRunner runner;
        protected FastStack thisStack = new FastStack(100);
        protected FastStack frameStack = new FastStack(100);
        protected FastStack contextStack;

        public SimpleRuntimeEnv() {
            this(SIMPLE_RUNNER, 0, new Object[0]);
        }

        SimpleRuntimeEnv(IOpenRunner runner, int frameSize, Object[] params) {
            Object[] aLocalFrame = new Object[frameSize];
            this.runner = runner;
            this.contextStack = new FastStack(5);
            System.arraycopy(params, 0, aLocalFrame, 0, params.length);
            this.pushLocalFrame(aLocalFrame);
            this.pushContext(this.buildDefaultRuntimeContext());
        }

        protected IRuntimeContext buildDefaultRuntimeContext() {
            return new DefaultRuntimeContext();
        }

        public SimpleRuntimeEnv(SimpleRuntimeEnv env) {
            this.runner = SIMPLE_RUNNER;
            this.contextStack = (FastStack)env.contextStack.clone();
            this.pushThis(env.getThis());
            this.pushLocalFrame(env.getLocalFrame());
        }

        @Override
        public Object[] getLocalFrame() {
            return (Object[])this.frameStack.peek();
        }

        @Override
        public IOpenRunner getRunner() {
            return this.runner;
        }

        @Override
        public Object getThis() {
            if (this.thisStack.size() == 0) {
                return null;
            }
            return this.thisStack.peek();
        }

        @Override
        public Object[] popLocalFrame() {
            return (Object[])this.frameStack.pop();
        }

        @Override
        public Object popThis() {
            return this.thisStack.pop();
        }

        @Override
        public void pushLocalFrame(Object[] frame) {
            this.frameStack.push((Object)frame);
        }

        @Override
        public void pushThis(Object thisObject) {
            this.thisStack.push(thisObject);
        }

        @Override
        public IRuntimeContext getContext() {
            if (this.contextStack.size() > 0) {
                return (IRuntimeContext)this.contextStack.peek();
            }
            throw new IllegalStateException("Context stack is empty!");
        }

        @Override
        public void setContext(IRuntimeContext context) {
            if (context == null) {
                context = this.buildDefaultRuntimeContext();
            }
            this.contextStack.clear();
            this.pushContext(context);
        }

        @Override
        public IRuntimeContext popContext() {
            if (this.contextStack.size() > 0) {
                return (IRuntimeContext)this.contextStack.pop();
            }
            throw new OpenLRuntimeException("Failed to restore context. The context modification history is empty.");
        }

        @Override
        public void pushContext(IRuntimeContext context) {
            this.contextStack.push((Object)context);
        }

        @Override
        public boolean isContextManagingSupported() {
            return true;
        }

        public IRuntimeEnv clone() {
            return new SimpleRuntimeEnv(this);
        }
    }

    static class SimpleRunner
    implements IOpenRunner {
        SimpleRunner() {
        }

        @Override
        public Object run(IBoundMethodNode node, Object[] params) throws OpenLRuntimeException {
            int frameSize = node.getLocalFrameSize();
            return node.evaluate(new SimpleRuntimeEnv(this, frameSize, params));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object run(IBoundMethodNode node, Object[] params, IRuntimeEnv env) throws OpenLRuntimeException {
            int frameSize = node.getLocalFrameSize();
            Object[] frame = new Object[frameSize];
            if (params != null && params.length > 0) {
                System.arraycopy(params, 0, frame, 0, params.length);
            }
            try {
                env.pushLocalFrame(frame);
                Object object = node.evaluate(env);
                return object;
            }
            finally {
                env.popLocalFrame();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object runExpression(IBoundNode expressionNode, Object[] params, IRuntimeEnv env) {
            try {
                env.pushLocalFrame(params);
                Object object = expressionNode.evaluate(env);
                return object;
            }
            finally {
                env.popLocalFrame();
            }
        }
    }
}

