/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.util;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Strings {
    public static boolean contains(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.contains(searchStr);
    }

    public static boolean contains(String str, char searchChar) {
        if (Strings.isEmpty0(str)) {
            return false;
        }
        return str.indexOf(searchChar) != -1;
    }

    public static boolean containsAny(String str, char ... chars) {
        if (Strings.isEmpty0(str) || chars == null || chars.length == 0) {
            return false;
        }
        for (char ch : chars) {
            if (str.indexOf(ch) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String str, String searchChars) {
        if (Strings.isEmpty0(str) || Strings.isEmpty0(searchChars)) {
            return false;
        }
        return Strings.containsAny(str, searchChars.toCharArray());
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !Strings.isEmpty(str);
    }

    public static int length(String str) {
        return str == null ? 0 : str.length();
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static boolean startsWith(String str, String prefix) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.startsWith(prefix);
    }

    public static boolean endsWith(String str, String suffix) {
        if (str == null || suffix == null) {
            return str == null && suffix == null;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        return str.endsWith(suffix);
    }

    public static String substr(String str, int pos, int length) {
        return Strings.substring(str, pos, pos + length);
    }

    public static String substring(String str, int beginIndex) {
        if (str == null) {
            return null;
        }
        if (beginIndex < 0) {
            beginIndex = str.length() + beginIndex;
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (beginIndex > str.length()) {
            return "";
        }
        return str.substring(beginIndex);
    }

    public static String substring(String str, int beginIndex, int endIndex) {
        if (str == null) {
            return null;
        }
        if (endIndex < 0) {
            endIndex = str.length() + endIndex;
        }
        if (beginIndex < 0) {
            beginIndex = str.length() + beginIndex;
        }
        if (endIndex > str.length()) {
            endIndex = str.length();
        }
        if (beginIndex > endIndex) {
            return "";
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0) {
            endIndex = 0;
        }
        return str.substring(beginIndex, endIndex);
    }

    public static String removeStart(String str, String remove) {
        if (Strings.isEmpty0(str) || Strings.isEmpty0(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeEnd(String str, String remove) {
        if (Strings.isEmpty0(str) || Strings.isEmpty0(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String replace(String str, String searchString, String replacement) {
        return Strings.replace(str, searchString, replacement, -1);
    }

    public static String replace(String str, String searchString, String replacement, int max) {
        if (Strings.isEmpty0(str) || Strings.isEmpty0(searchString) || replacement == null || max == 0) {
            return str;
        }
        int start = 0;
        int end = str.indexOf(searchString, start);
        if (end == -1) {
            return str;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(str.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(str.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = str.indexOf(searchString, start);
        }
        buf.append(str.substring(start));
        return buf.toString();
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Double || obj instanceof Float || obj instanceof BigDecimal) {
            return obj.toString().replaceAll("(\\.0+$)|(?<=\\.\\d{0,20})0+$", "");
        }
        return obj.toString();
    }

    public static String toString(Date date) {
        return Strings.toString(date, null);
    }

    public static String toString(Date date, String pattern) {
        return date == null ? null : new SimpleDateFormat(pattern == null ? "MM/dd/yyyy" : pattern, Locale.US).format(date);
    }

    public static Integer toInteger(String str) {
        return Strings.isEmpty(str) ? null : Integer.valueOf(str);
    }

    public static Double toDouble(String str) {
        return Strings.isEmpty(str) ? null : Double.valueOf(str);
    }

    public static Number toNumber(String str) throws ParseException {
        if (Strings.isEmpty(str)) {
            return null;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number parsed = NumberFormat.getInstance(Locale.US).parse(str, parsePosition);
        if (parsePosition.getIndex() != str.length()) {
            throw new ParseException("Unparseable number: \"" + str + "\"", parsePosition.getIndex());
        }
        return parsed;
    }

    public static Date toDate(String str) throws ParseException {
        return Strings.isEmpty(str) ? null : Strings.getDateFormat().parse(str);
    }

    private static DateFormat getDateFormat() {
        DateFormat df = DateFormat.getDateInstance(3, Locale.US);
        df.setLenient(false);
        df.getCalendar().set(0, 0, 0, 0, 0, 0);
        df.getCalendar().set(14, 0);
        return df;
    }

    public static String concatenate(Object ... objects) {
        if (objects == null || objects.length == 0) {
            return null;
        }
        StringBuilder builder = null;
        for (Object obj : objects) {
            if (obj == null) continue;
            if (builder == null) {
                builder = new StringBuilder(16 * objects.length);
            }
            builder.append(obj);
        }
        return builder == null ? null : builder.toString();
    }

    private static boolean isEmpty0(String str) {
        return str == null || str.isEmpty();
    }
}

