/*
 * Decompiled with CFR 0.152.
 */
package org.openl.domain;

import java.util.NoSuchElementException;
import org.openl.domain.IIntIterator;
import org.openl.domain.IIntSelector;
import org.openl.domain.IntArrayIterator;
import org.openl.util.AOpenIterator;

public abstract class AIntIterator
extends AOpenIterator<Integer>
implements IIntIterator {
    private static final IIntIterator INT_EMPTY = new IntEmptyIterator();

    @Override
    public Integer next() {
        return this.nextInt();
    }

    @Override
    public IIntIterator select(IIntSelector selector) {
        return new IIntSelector.IntSelectIterator(this, selector);
    }

    public static IIntIterator fromValue(int ... values) {
        int len = values.length;
        if (len == 0) {
            return INT_EMPTY;
        }
        if (len == 1) {
            return new SingleIntIterator(values[0]);
        }
        return new IntArrayIterator(values);
    }

    static final class IntEmptyIterator
    extends AIntIterator {
        IntEmptyIterator() {
        }

        @Override
        public int nextInt() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean isResetable() {
            return true;
        }

        @Override
        public void reset() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    static final class SingleIntIterator
    extends AIntIterator {
        int value;
        boolean hasNext = true;

        SingleIntIterator(int value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.value;
        }

        @Override
        public final int size() {
            return this.hasNext ? 1 : 0;
        }

        @Override
        public boolean isResetable() {
            return true;
        }

        @Override
        public void reset() {
            this.hasNext = true;
        }
    }
}

