/*
 * Decompiled with CFR 0.152.
 */
package org.openl.domain;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.apache.commons.lang3.time.DateUtils;
import org.openl.domain.FixedSizeDomain;
import org.openl.domain.IType;

public class DateRangeDomain
extends FixedSizeDomain<Date> {
    private Calendar min = new GregorianCalendar();
    private Calendar max = new GregorianCalendar();
    private static final long ONE_HOUR = 3600000L;

    public DateRangeDomain(Date min, Date max) {
        this.setMin(min);
        this.setMax(max);
    }

    public DateRangeDomain(int yearsPeriond) {
        this(DateRangeDomain.min(yearsPeriond), DateRangeDomain.max(yearsPeriond));
    }

    private static Date min(int yearsPeriond) {
        Calendar date = Calendar.getInstance();
        date.add(1, -yearsPeriond);
        return date.getTime();
    }

    private static Date max(int yearsPeriond) {
        Calendar date = Calendar.getInstance();
        date.add(1, yearsPeriond);
        return date.getTime();
    }

    public Date getMin() {
        return this.min.getTime();
    }

    public Date getMax() {
        return this.max.getTime();
    }

    public void setMin(Date min) {
        this.min.setTime(DateUtils.truncate((Date)min, (int)5));
    }

    public void setMax(Date max) {
        this.max.setTime(DateUtils.truncate((Date)max, (int)5));
    }

    @Override
    public Iterator<Date> iterator() {
        return new DateIterator();
    }

    public static long daysBetween(Calendar d1, Calendar d2) {
        return (d2.getTimeInMillis() - d1.getTimeInMillis() + 3600000L) / 86400000L;
    }

    @Override
    public int size() {
        return (int)DateRangeDomain.daysBetween(this.min, this.max) + 1;
    }

    @Override
    public IType getElementType() {
        return null;
    }

    @Override
    public boolean selectObject(Date obj) {
        return obj.before(this.max.getTime()) && obj.after(this.min.getTime());
    }

    @Override
    public boolean selectType(IType type) {
        return false;
    }

    public int getIndex(Date value) {
        if (value.after(this.getMax())) {
            return -1;
        }
        GregorianCalendar date = new GregorianCalendar();
        date.setTime(value);
        return (int)DateRangeDomain.daysBetween(this.min, date);
    }

    public Date getValue(int index) {
        if (index >= this.size()) {
            return null;
        }
        Calendar date = (Calendar)this.min.clone();
        date.add(5, index);
        return date.getTime();
    }

    public String toString() {
        return "[" + this.getMin() + ";" + this.getMax() + "]";
    }

    private class DateIterator
    implements Iterator<Date> {
        private Calendar current;

        DateIterator() {
            this.current = (Calendar)DateRangeDomain.this.min.clone();
            this.current.add(5, -1);
        }

        @Override
        public boolean hasNext() {
            return this.current.before(DateRangeDomain.this.max);
        }

        @Override
        public Date next() {
            this.current.add(5, 1);
            return this.current.getTime();
        }

        @Override
        public void remove() {
        }
    }
}

