/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.lang.reflect.Array;
import org.openl.util.AOpenIterator;
import org.openl.util.IOpenIterator;

public abstract class AIndexedIterator<T>
extends AOpenIterator<T> {
    int from = 0;
    int current;
    int step = 1;
    int to = -1;

    protected AIndexedIterator(int from, int to, int step) {
        this.from = from;
        this.to = to;
        this.step = step;
        this.current = from;
    }

    @Override
    public final boolean hasNext() {
        return this.step > 0 ? this.current < this.to : this.current > this.to;
    }

    protected abstract T indexedElement(int var1);

    @Override
    public T next() {
        int idx = this.current;
        this.current += this.step;
        return this.indexedElement(idx);
    }

    protected void reverseIndexes() {
        int s = this.size();
        if (s <= 0) {
            return;
        }
        int newFrom = this.from + (s - 1) * this.step;
        this.step = -this.step;
        this.to = newFrom + s * this.step;
        this.current = this.from = newFrom;
    }

    @Override
    public final int size() {
        return this.step > 0 ? (this.to - this.from) / this.step : (this.from - this.to) / -this.step;
    }

    static class ArrayIterator<T>
    extends AIndexedIterator<T> {
        T[] ary;

        ArrayIterator(T[] ary) {
            super(0, ary.length, 1);
            this.ary = ary;
        }

        ArrayIterator(T[] ary, int from, int to, int step) {
            super(from, to, step);
            this.ary = ary;
        }

        @Override
        protected T indexedElement(int i) {
            return this.ary[i];
        }

        @Override
        public IOpenIterator<T> reverse() {
            ArrayIterator<T> it = new ArrayIterator<T>(this.ary, this.from, this.to, this.step);
            it.reverseIndexes();
            return it;
        }
    }

    static class AnyArrayIterator
    extends AIndexedIterator<Object> {
        Object ary;

        AnyArrayIterator(Object ary) {
            super(0, Array.getLength(ary), 1);
            this.ary = ary;
        }

        AnyArrayIterator(Object ary, int from, int to, int step) {
            super(from, to, step);
            this.ary = ary;
        }

        @Override
        protected Object indexedElement(int i) {
            return Array.get(this.ary, i);
        }

        @Override
        public IOpenIterator<Object> reverse() {
            AnyArrayIterator it = new AnyArrayIterator(this.ary, this.from, this.to, this.step);
            it.reverseIndexes();
            return it;
        }
    }
}

