/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.openl.util.IConvertor;
import org.openl.util.IOpenIterator;
import org.openl.util.ISelector;

public abstract class AOpenIterator<T>
implements IOpenIterator<T> {
    public static final EmptyIterator<?> EMPTY = new EmptyIterator();

    public static <T> IOpenIterator<T> empty() {
        return EMPTY;
    }

    public static <X> IOpenIterator<X> reverse(Iterator<X> it) {
        if (it instanceof IOpenIterator) {
            return ((IOpenIterator)it).reverse();
        }
        throw new UnsupportedOperationException();
    }

    public static <X> IOpenIterator<X> select(Iterator<X> it, ISelector<X> is) {
        return new SelectIterator<X>(it, is);
    }

    @Override
    public <C> IOpenIterator<C> collect(IConvertor<T, C> ic) {
        return new CollectIterator<T, C>(this, ic);
    }

    @Override
    public void remove() {
        throw new IllegalStateException();
    }

    @Override
    public IOpenIterator<T> reverse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IOpenIterator<T> select(ISelector<T> is) {
        return new SelectIterator<T>(this, is);
    }

    @Override
    public int size() {
        return -1;
    }

    static class SimpleIteratorWrapper<T>
    extends IteratorWrapper<T, T> {
        SimpleIteratorWrapper(Iterator<T> it) {
            super(it);
        }

        @Override
        public T next() {
            return (T)this.it.next();
        }
    }

    static final class SelectIterator<T>
    extends IteratorWrapper<T, T> {
        ISelector<T> selector;
        T next;
        boolean hasNext = false;

        SelectIterator(Iterator<T> it, ISelector<T> selector) {
            super(it);
            this.selector = selector;
        }

        void findNext() {
            while (this.it.hasNext()) {
                Object obj = this.it.next();
                if (!this.selector.select(obj)) continue;
                this.next = obj;
                this.hasNext = true;
                return;
            }
            this.next = null;
            this.hasNext = false;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasNext) {
                this.findNext();
            }
            return this.hasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            this.hasNext = false;
            return this.next;
        }
    }

    static abstract class IteratorWrapper<T, C>
    extends AOpenIterator<C> {
        protected Iterator<T> it;

        IteratorWrapper(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public abstract C next();
    }

    static final class EmptyIterator<T>
    extends AOpenIterator<T> {
        EmptyIterator() {
        }

        @Override
        public <C> IOpenIterator<C> collect(IConvertor<T, C> ic) {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException("EmptyIterator");
        }

        @Override
        public IOpenIterator<T> reverse() {
            return this;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    static final class CollectIterator<T, C>
    extends IteratorWrapper<T, C> {
        IConvertor<T, C> collector;

        CollectIterator(Iterator<T> it, IConvertor<T, C> convertor) {
            super(it);
            this.collector = convertor;
        }

        @Override
        public C next() {
            return this.collector.convert(this.it.next());
        }
    }
}

