/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;

public class ClassUtils {
    private static final Method DEFINE_CLASS;
    private static final ProtectionDomain PROTECTION_DOMAIN;
    private static final Throwable THROWABLE;

    public static Class<?> defineClass(String className, byte[] b, ClassLoader loader) throws Exception {
        if (DEFINE_CLASS == null) {
            throw new IllegalStateException(THROWABLE);
        }
        Object[] args = new Object[]{className, b, new Integer(0), new Integer(b.length), PROTECTION_DOMAIN};
        Class clazz = (Class)DEFINE_CLASS.invoke((Object)loader, args);
        Class.forName(className, true, loader);
        return clazz;
    }

    public static Class<?> primitiveToWrapper(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        if (!cls.isPrimitive()) {
            return cls;
        }
        if (cls == Double.TYPE) {
            return Double.class;
        }
        if (cls == Integer.TYPE) {
            return Integer.class;
        }
        if (cls == Boolean.TYPE) {
            return Boolean.class;
        }
        if (cls == Long.TYPE) {
            return Long.class;
        }
        if (cls == Float.TYPE) {
            return Float.class;
        }
        if (cls == Void.TYPE) {
            return Void.TYPE;
        }
        if (cls == Character.TYPE) {
            return Character.class;
        }
        if (cls == Short.TYPE) {
            return Short.class;
        }
        if (cls == Byte.TYPE) {
            return Byte.class;
        }
        throw new IllegalStateException("No wrappers are for the primitive: " + cls);
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        if (cls == Double.class) {
            return Double.TYPE;
        }
        if (cls == Integer.class) {
            return Integer.TYPE;
        }
        if (cls == Boolean.class) {
            return Boolean.TYPE;
        }
        if (cls == Long.class) {
            return Long.TYPE;
        }
        if (cls == Float.class) {
            return Float.TYPE;
        }
        if (cls == Void.TYPE) {
            return Void.TYPE;
        }
        if (cls == Character.class) {
            return Character.TYPE;
        }
        if (cls == Short.class) {
            return Short.TYPE;
        }
        if (cls == Byte.class) {
            return Byte.TYPE;
        }
        return null;
    }

    public static String getShortClassName(Class<?> cls) {
        if (cls == null) {
            return "";
        }
        String canonicalName = cls.getCanonicalName();
        if (canonicalName == null) {
            return "";
        }
        String packageName = ClassUtils.getPackageName(cls);
        if (packageName.isEmpty()) {
            return canonicalName;
        }
        return canonicalName.substring(packageName.length() + 1);
    }

    public static String getPackageName(Class<?> cls) {
        if (cls == null) {
            return "";
        }
        String className = cls.getName();
        int lastDot = className.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        int arrayIndex = className.indexOf("[L");
        int start = arrayIndex == -1 ? 0 : arrayIndex + 2;
        return className.substring(start, lastDot);
    }

    public static boolean isAssignable(Class<?> cls, Class<?> toClass) {
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (toClass.isPrimitive() && !cls.isPrimitive()) {
            if ((cls = ClassUtils.wrapperToPrimitive(cls)) == null) {
                return false;
            }
        } else if (cls.isPrimitive() && !toClass.isPrimitive()) {
            cls = ClassUtils.primitiveToWrapper(cls);
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    static {
        Method dc;
        ProtectionDomain pd;
        Throwable th = null;
        try {
            pd = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ClassUtils.class.getProtectionDomain();
                }
            });
            dc = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Class<?> loader = Class.forName("java.lang.ClassLoader");
                    Method defineClass = loader.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                    defineClass.setAccessible(true);
                    return defineClass;
                }
            });
        }
        catch (Throwable e) {
            th = e;
            dc = null;
            pd = null;
        }
        DEFINE_CLASS = dc;
        PROTECTION_DOMAIN = pd;
        THROWABLE = th;
    }
}

