/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.openl.util.StringUtils;

public class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copyAndClose(InputStream input, OutputStream output) throws IOException {
        try {
            IOUtils.copy(input, output);
        }
        finally {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
        }
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        IOUtils.copy(input, output, new byte[8192]);
    }

    public static void copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        while ((n = input.read(buffer)) > 0) {
            output.write(buffer, 0, n);
        }
        output.flush();
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        int n;
        char[] buffer = new char[8192];
        while ((n = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, n);
        }
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toStringAndClose(InputStream input) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            InputStreamReader reader = new InputStreamReader(input, StringUtils.UTF_8);
            IOUtils.copy(reader, writer);
            String string = writer.toString();
            return string;
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    public static InputStream toInputStream(CharSequence input) {
        return new ByteArrayInputStream(StringUtils.toBytes(input));
    }
}

