/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;

public class StringUtils {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String EMPTY = "";

    public static byte[] toBytes(CharSequence input) {
        return input.toString().getBytes(UTF_8);
    }

    public static String[] split(String str, final char separator) {
        return StringUtils.splitWorker(str, new Predicate(){

            @Override
            public boolean evaluate(char ch) {
                return ch == separator;
            }
        }, true);
    }

    public static String[] split(String str) {
        return StringUtils.splitWorker(str, new Predicate(){

            @Override
            public boolean evaluate(char ch) {
                return Character.isWhitespace(ch);
            }
        }, false);
    }

    private static String[] splitWorker(String str, Predicate tester, boolean trim) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        int end = 0;
        boolean match = false;
        while (i < len) {
            char ch;
            if (tester.evaluate(ch = str.charAt(i++))) {
                if (match) {
                    list.add(str.substring(start, end));
                    match = false;
                }
                start = i;
                continue;
            }
            if (trim && Character.isWhitespace(ch)) {
                if (match) continue;
                start = i;
                continue;
            }
            match = true;
            end = i;
        }
        if (match) {
            list.add(str.substring(start, end));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String join(Object[] values, String separator) {
        if (values == null) {
            return null;
        }
        return StringUtils.join(Arrays.asList(values), separator);
    }

    public static String join(Iterable<?> values, String separator) {
        if (values == null) {
            return null;
        }
        if (separator == null) {
            separator = EMPTY;
        }
        StringBuilder builder = new StringBuilder();
        boolean prependComma = false;
        for (Object value : values) {
            if (prependComma) {
                builder.append(separator);
            }
            if (value != null) {
                builder.append(value);
            }
            prependComma = true;
        }
        return builder.toString();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return true;
        }
        int strLen = cs.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == str2) {
            return true;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public static boolean notEquals(String str1, String str2) {
        return !StringUtils.equals(str1, str2);
    }

    public static boolean containsIgnoreCase(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        int len = searchStr.length();
        int end = str.length() - len;
        for (int i = 0; i <= end; ++i) {
            if (!str.regionMatches(true, i, searchStr, 0, len)) continue;
            return true;
        }
        return false;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String trimToNull(String str) {
        String ts = StringUtils.trim(str);
        return StringUtils.isEmpty(ts) ? null : ts;
    }

    public static String trimToEmpty(String str) {
        return str == null ? EMPTY : str.trim();
    }

    public static String removeStart(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.startsWith(remove)) {
            return str.substring(remove.length());
        }
        return str;
    }

    public static String removeEnd(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String capitalize(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isTitleCase(firstChar)) {
            return str;
        }
        return new StringBuilder(str.length()).append(Character.toTitleCase(firstChar)).append(str, 1, str.length()).toString();
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        char firstChar = str.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return str;
        }
        return new StringBuilder(strLen).append(Character.toLowerCase(firstChar)).append(str.substring(1)).toString();
    }

    private static interface Predicate {
        public boolean evaluate(char var1);
    }
}

