/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openl.util.TopoSortCycleException;

public final class TopoSort<T> {
    ArrayList<T> roots = new ArrayList();
    HashMap<T, Counter> leaves = new HashMap();
    HashMap<T, List<T>> dependents = new HashMap();

    public static <T> List<T> sort(IPair<T>[] pairs) throws TopoSortCycleException {
        int len = pairs.length;
        TopoSort<T> ts = new TopoSort<T>();
        for (int i = 0; i < len; ++i) {
            ts.addOrderedPair(pairs[i].getRoot(), pairs[i].getLeaf());
        }
        return ts.sort();
    }

    public static <T> List<T> sort(List<T> roots, List<T> leaves) throws TopoSortCycleException {
        int len = roots.size();
        TopoSort<T> ts = new TopoSort<T>();
        for (int i = 0; i < len; ++i) {
            ts.addOrderedPair(roots.get(i), leaves.get(i));
        }
        return ts.sort();
    }

    public static <T> List<T> sort(T[] aryRoots, T[] aryLeaves) throws TopoSortCycleException {
        int len = aryRoots.length;
        TopoSort<T> ts = new TopoSort<T>();
        for (int i = 0; i < len; ++i) {
            ts.addOrderedPair(aryRoots[i], aryLeaves[i]);
        }
        return ts.sort();
    }

    public static <T> List<T> sort(T[][] nx2) throws TopoSortCycleException {
        int len = nx2.length;
        TopoSort<T> ts = new TopoSort<T>();
        for (int i = 0; i < len; ++i) {
            ts.addOrderedPair(nx2[i][0], nx2[i][1]);
        }
        return ts.sort();
    }

    public void addOrderedPair(T root, T leaf) {
        if (leaf != null) {
            Counter cnt = this.leaves.get(leaf);
            if (cnt == null) {
                cnt = new Counter();
                this.leaves.put(leaf, cnt);
            }
            ++cnt.cnt;
            this.roots.remove(leaf);
            List<T> deps = this.dependents.get(root);
            if (deps == null) {
                deps = new ArrayList<T>();
                this.dependents.put(root, deps);
            }
            deps.add(leaf);
        }
        if (!this.roots.contains(root) && !this.leaves.containsKey(root)) {
            this.roots.add(root);
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<T> sort() throws TopoSortCycleException {
        res = new ArrayList<T>();
        block0: while (true) {
            if ((roots_size = this.roots.size()) == 0) {
                if (this.leaves.size() > 0) {
                    throw new TopoSortCycleException(this.leaves.keySet());
                }
                return res;
            }
            root = this.roots.get(roots_size - 1);
            res.add(root);
            this.roots.remove(roots_size - 1);
            deps = this.dependents.get(root);
            if (deps == null) continue;
            iter = deps.iterator();
            while (true) {
                if (iter.hasNext()) ** break;
                continue block0;
                dep = iter.next();
                cnt = this.leaves.get(dep);
                if (--cnt.cnt != 0) continue;
                this.leaves.remove(dep);
                this.roots.add(dep);
            }
            break;
        }
    }

    public static interface IPair<T> {
        public T getLeaf();

        public T getRoot();
    }

    static class Counter {
        int cnt = 0;

        Counter() {
        }
    }
}

