/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.db;

import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCDriverRegister {
    public static void registerDrivers() {
        String[] drivers = StringUtils.split(System.getProperty("jdbc.drivers"), ':');
        JDBCDriverRegister.registerDrivers(drivers);
        JDBCDriverRegister.registerDrivers("com.mysql.jdbc.Driver", "org.mariadb.jdbc.Driver", "com.ibm.db2.jcc.DB2Driver", "oracle.jdbc.OracleDriver", "org.postgresql.Driver", "org.hsqldb.jdbcDriver", "org.h2.Driver", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
    }

    private static void registerDrivers(String ... drivers) {
        if (drivers == null) {
            return;
        }
        Logger log = LoggerFactory.getLogger(JDBCDriverRegister.class);
        for (String driver : drivers) {
            try {
                Class.forName(driver);
                log.info("JDBC Driver: '{}' - OK.", (Object)driver);
            }
            catch (ClassNotFoundException e) {
                log.info("JDBC Driver: '{}' - NOT FOUND.", (Object)driver);
            }
        }
    }

    public void init() {
        JDBCDriverRegister.registerDrivers();
    }
}

