/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.factory;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.openl.util.factory.Factory;

public class CacheableFactory<K, V>
implements Factory<K, V> {
    private final ConcurrentMap<K, V> cache = new ConcurrentHashMap();
    private final Factory<K, V> factory;

    public CacheableFactory(Factory<K, V> factory) {
        this.factory = factory;
    }

    @Override
    public V create(K param) {
        V saved;
        Object value = this.cache.get(param);
        if (value == null && (saved = this.cache.putIfAbsent(param, value = this.factory.create(param))) != null) {
            value = saved;
        }
        return value;
    }
}

