/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.formatters;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.openl.util.formatters.IFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateFormatter
implements IFormatter {
    private final Logger log = LoggerFactory.getLogger(DateFormatter.class);
    private DateFormat format;

    public DateFormatter() {
        this(new SimpleDateFormat());
    }

    public DateFormatter(Locale locale) {
        this(DateFormat.getDateTimeInstance(3, 3, locale == null ? Locale.getDefault() : locale));
    }

    public DateFormatter(DateFormat format) {
        this.format = format;
    }

    public DateFormatter(String format) {
        try {
            this.format = new SimpleDateFormat(format);
        }
        catch (Exception e) {
            this.log.error("Could not create format: {}", (Object)format);
            this.format = new SimpleDateFormat();
        }
    }

    public DateFormatter(String format, Locale locale) {
        try {
            this.format = new SimpleDateFormat(format, locale);
        }
        catch (Exception e) {
            this.log.error("Could not create format: {}", (Object)format);
            this.format = DateFormat.getDateTimeInstance(3, 3, locale == null ? Locale.getDefault() : locale);
        }
    }

    @Override
    public String format(Object value) {
        if (!(value instanceof Date)) {
            this.log.debug("Should be Date: {}", value);
            return null;
        }
        return this.format.format(value);
    }

    @Override
    public Object parse(String value) {
        if (value == null) {
            return null;
        }
        try {
            return this.format.parse(value);
        }
        catch (ParseException e) {
            this.log.debug("Could not parse Date: {}", (Object)value, (Object)e);
            return null;
        }
    }
}

