/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.math.NumberUtils;
import org.openl.util.ArrayTool;

public class MathUtils {
    private static <T extends Number> double[] numberArrayToDoubleArray(T[] values) {
        if (values == null) {
            return null;
        }
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            doubleArray[i] = ((Number)values[i]).doubleValue();
        }
        return doubleArray;
    }

    private static double[] byteArrayToDoubleArray(byte[] values) {
        if (values == null) {
            return null;
        }
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    private static double[] shortArrayToDoubleArray(short[] values) {
        if (values == null) {
            return null;
        }
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    private static double[] intArrayToDoubleArray(int[] values) {
        if (values == null) {
            return null;
        }
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    private static double[] longArrayToDoubleArray(long[] values) {
        if (values == null) {
            return null;
        }
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    private static double[] floatArrayToDoubleArray(float[] values) {
        if (values == null) {
            return null;
        }
        double[] doubleArray = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubleArray[i] = values[i];
        }
        return doubleArray;
    }

    public static boolean max(byte value1, byte value2) {
        return value1 > value2;
    }

    public static boolean max(short value1, short value2) {
        return value1 > value2;
    }

    public static boolean max(int value1, int value2) {
        return value1 > value2;
    }

    public static boolean max(long value1, long value2) {
        return value1 > value2;
    }

    public static boolean max(float value1, float value2) {
        return value1 > value2;
    }

    public static boolean max(double value1, double value2) {
        return value1 > value2;
    }

    public static <T extends Comparable<T>> Boolean max(T value1, T value2) {
        if (value1 == null || value2 == null) {
            return null;
        }
        if (value1.compareTo(value2) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static <T extends Comparable<T>> T max(T[] values) {
        if (values == null) {
            return null;
        }
        if ((values = (Comparable[])ArrayTool.removeNulls(values)).length == 0) {
            return null;
        }
        T max = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i].compareTo(max) <= 0) continue;
            max = values[i];
        }
        return max;
    }

    public static Byte max(byte[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return NumberUtils.max((byte[])values);
    }

    public static Short max(short[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return NumberUtils.max((short[])values);
    }

    public static Integer max(int[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return NumberUtils.max((int[])values);
    }

    public static Long max(long[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return NumberUtils.max((long[])values);
    }

    public static Float max(float[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return Float.valueOf(NumberUtils.max((float[])values));
    }

    public static Double max(double[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return NumberUtils.max((double[])values);
    }

    public static boolean min(byte value1, byte value2) {
        return value1 < value2;
    }

    public static boolean min(short value1, short value2) {
        return value1 < value2;
    }

    public static boolean min(int value1, int value2) {
        return value1 < value2;
    }

    public static boolean min(long value1, long value2) {
        return value1 < value2;
    }

    public static boolean min(float value1, float value2) {
        return value1 < value2;
    }

    public static boolean min(double value1, double value2) {
        return value1 < value2;
    }

    public static <T extends Comparable<T>> Boolean min(T value1, T value2) {
        if (value1 == null || value2 == null) {
            return null;
        }
        if (value1.compareTo(value2) < 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static <T extends Comparable<T>> T min(T[] values) {
        if (values == null) {
            return null;
        }
        if ((values = (Comparable[])ArrayTool.removeNulls(values)).length == 0) {
            return null;
        }
        T min = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (values[i].compareTo(min) >= 0) continue;
            min = values[i];
        }
        return min;
    }

    public static Byte min(byte[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return NumberUtils.min((byte[])values);
    }

    public static Short min(short[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return NumberUtils.min((short[])values);
    }

    public static Integer min(int[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return NumberUtils.min((int[])values);
    }

    public static Long min(long[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return NumberUtils.min((long[])values);
    }

    public static Float min(float[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return Float.valueOf(NumberUtils.min((float[])values));
    }

    public static Double min(double[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        return NumberUtils.min((double[])values);
    }

    public static <T extends Number> Double avg(T[] values) {
        if (values == null) {
            return null;
        }
        if ((values = (Number[])ArrayTool.removeNulls(values)).length == 0) {
            return null;
        }
        double[] doubleValues = MathUtils.numberArrayToDoubleArray(values);
        return MathUtils.sum(doubleValues) / (double)values.length;
    }

    public static Float avg(Float[] values) {
        if (values == null) {
            return null;
        }
        if ((values = ArrayTool.removeNulls(values)).length == 0) {
            return null;
        }
        return Float.valueOf(MathUtils.sum(values).floatValue() / (float)values.length);
    }

    public static BigDecimal avg(BigInteger[] values) {
        if (values == null) {
            return null;
        }
        if ((values = ArrayTool.removeNulls(values)).length == 0) {
            return null;
        }
        return MathUtils.divide(new BigDecimal(MathUtils.sum(values)), BigDecimal.valueOf(values.length));
    }

    public static BigDecimal avg(BigDecimal[] values) {
        if (values == null) {
            return null;
        }
        if ((values = ArrayTool.removeNulls(values)).length == 0) {
            return null;
        }
        return MathUtils.divide(MathUtils.sum(values), BigDecimal.valueOf(values.length));
    }

    public static Double avg(byte[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        double sum = 0.0;
        for (byte a : values) {
            sum += (double)a;
        }
        return sum / (double)values.length;
    }

    public static Double avg(short[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        double sum = 0.0;
        for (short a : values) {
            sum += (double)a;
        }
        return sum / (double)values.length;
    }

    public static Double avg(int[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        double sum = 0.0;
        for (int a : values) {
            sum += (double)a;
        }
        return sum / (double)values.length;
    }

    public static Double avg(long[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        double sum = 0.0;
        for (long a : values) {
            sum += (double)a;
        }
        return sum / (double)values.length;
    }

    public static Float avg(float[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        float sum = 0.0f;
        for (float a : values) {
            sum += a;
        }
        return Float.valueOf(sum / (float)values.length);
    }

    public static Double avg(double[] values) {
        if (values == null || values.length == 0) {
            return null;
        }
        double sum = 0.0;
        for (double a : values) {
            sum += a;
        }
        return sum / (double)values.length;
    }

    public static <T extends Comparable<T>> T small(T[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        values = (Comparable[])ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Object[] v = (Comparable[])values.clone();
        Arrays.sort(v);
        return (T)v[index];
    }

    public static Byte small(byte[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        byte[] v = (byte[])values.clone();
        Arrays.sort(v);
        return v[index];
    }

    public static Short small(short[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        short[] v = (short[])values.clone();
        Arrays.sort(v);
        return v[index];
    }

    public static Integer small(int[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        int[] v = (int[])values.clone();
        Arrays.sort(v);
        return v[index];
    }

    public static Long small(long[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        long[] v = (long[])values.clone();
        Arrays.sort(v);
        return v[index];
    }

    public static Float small(float[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        float[] v = (float[])values.clone();
        Arrays.sort(v);
        return Float.valueOf(v[index]);
    }

    public static Double small(double[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        double[] v = (double[])values.clone();
        Arrays.sort(v);
        return v[index];
    }

    public static <T extends Comparable<T>> T big(T[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        values = (Comparable[])ArrayTool.removeNulls(values);
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        Object[] v = (Comparable[])values.clone();
        Arrays.sort(v);
        return (T)v[v.length - 1 - index];
    }

    public static Byte big(byte[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        byte[] v = (byte[])values.clone();
        Arrays.sort(v);
        return v[v.length - 1 - index];
    }

    public static Short big(short[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        short[] v = (short[])values.clone();
        Arrays.sort(v);
        return v[v.length - 1 - index];
    }

    public static Integer big(int[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        int[] v = (int[])values.clone();
        Arrays.sort(v);
        return v[v.length - 1 - index];
    }

    public static Long big(long[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        long[] v = (long[])values.clone();
        Arrays.sort(v);
        return v[v.length - 1 - index];
    }

    public static Float big(float[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        float[] v = (float[])values.clone();
        Arrays.sort(v);
        return Float.valueOf(v[v.length - 1 - index]);
    }

    public static Double big(double[] values, int position) {
        int index = position - 1;
        if (values == null) {
            return null;
        }
        if (index < 0 || values.length <= index) {
            throw new IllegalArgumentException(String.format("There is no position '%d' in the given array", position));
        }
        double[] v = (double[])values.clone();
        Arrays.sort(v);
        return v[v.length - 1 - index];
    }

    private static <T extends Number> T sum(T[] values, Adder<T> adder) {
        if (values == null) {
            return null;
        }
        T sum = adder.zero();
        for (T value : values) {
            if (value == null) continue;
            sum = adder.add(sum, value);
        }
        return sum;
    }

    public static Byte sum(Byte[] values) {
        return (Byte)MathUtils.sum((Number[])values, (Adder)new Adder<Byte>(){

            @Override
            public Byte add(Byte a, Byte b) {
                return (byte)(a + b);
            }

            @Override
            public Byte zero() {
                return (byte)0;
            }
        });
    }

    public static Short sum(Short[] values) {
        return (Short)MathUtils.sum((Number[])values, (Adder)new Adder<Short>(){

            @Override
            public Short add(Short a, Short b) {
                return (short)(a + b);
            }

            @Override
            public Short zero() {
                return (short)0;
            }
        });
    }

    public static Integer sum(Integer[] values) {
        return (Integer)MathUtils.sum((Number[])values, (Adder)new Adder<Integer>(){

            @Override
            public Integer add(Integer a, Integer b) {
                return a + b;
            }

            @Override
            public Integer zero() {
                return 0;
            }
        });
    }

    public static Long sum(Long[] values) {
        return (Long)MathUtils.sum((Number[])values, (Adder)new Adder<Long>(){

            @Override
            public Long add(Long a, Long b) {
                return a + b;
            }

            @Override
            public Long zero() {
                return 0L;
            }
        });
    }

    public static Float sum(Float[] values) {
        return (Float)MathUtils.sum((Number[])values, (Adder)new Adder<Float>(){

            @Override
            public Float add(Float a, Float b) {
                return Float.valueOf(a.floatValue() + b.floatValue());
            }

            @Override
            public Float zero() {
                return Float.valueOf(0.0f);
            }
        });
    }

    public static Double sum(Double[] values) {
        return (Double)MathUtils.sum((Number[])values, (Adder)new Adder<Double>(){

            @Override
            public Double add(Double a, Double b) {
                return a + b;
            }

            @Override
            public Double zero() {
                return 0.0;
            }
        });
    }

    public static BigInteger sum(BigInteger[] values) {
        return (BigInteger)MathUtils.sum((Number[])values, (Adder)new Adder<BigInteger>(){

            @Override
            public BigInteger add(BigInteger a, BigInteger b) {
                return a.add(b);
            }

            @Override
            public BigInteger zero() {
                return BigInteger.ZERO;
            }
        });
    }

    public static BigDecimal sum(BigDecimal[] values) {
        return (BigDecimal)MathUtils.sum((Number[])values, (Adder)new Adder<BigDecimal>(){

            @Override
            public BigDecimal add(BigDecimal a, BigDecimal b) {
                return a.add(b);
            }

            @Override
            public BigDecimal zero() {
                return BigDecimal.ZERO;
            }
        });
    }

    public static Byte sum(byte[] values) {
        if (values == null) {
            return null;
        }
        byte sum = 0;
        for (byte a : values) {
            sum = (byte)(sum + a);
        }
        return sum;
    }

    public static Short sum(short[] values) {
        if (values == null) {
            return null;
        }
        short sum = 0;
        for (short a : values) {
            sum = (short)(sum + a);
        }
        return sum;
    }

    public static Integer sum(int[] values) {
        if (values == null) {
            return null;
        }
        int sum = 0;
        for (int a : values) {
            sum += a;
        }
        return sum;
    }

    public static Long sum(long[] values) {
        if (values == null) {
            return null;
        }
        long sum = 0L;
        for (long a : values) {
            sum += a;
        }
        return sum;
    }

    public static Float sum(float[] values) {
        if (values == null) {
            return null;
        }
        float sum = 0.0f;
        for (float a : values) {
            sum += a;
        }
        return Float.valueOf(sum);
    }

    public static Double sum(double[] values) {
        if (values == null) {
            return null;
        }
        double sum = 0.0;
        for (double a : values) {
            sum += a;
        }
        return sum;
    }

    private static <T extends Number, R extends Number> R product(T[] values, Multiplicator<T, R> multiplicator) {
        if (values == null) {
            return null;
        }
        boolean hasValues = false;
        R res = multiplicator.one();
        for (T value : values) {
            if (value == null) continue;
            res = multiplicator.multiply(res, value);
            hasValues = true;
        }
        return hasValues ? res : multiplicator.zero();
    }

    public static Long product(Byte[] values) {
        return (Long)MathUtils.product((Number[])values, (Multiplicator)new Multiplicator<Byte, Long>(){

            @Override
            public Long multiply(Long a, Byte b) {
                return a * (long)b.byteValue();
            }

            @Override
            public Long one() {
                return 1L;
            }

            @Override
            public Long zero() {
                return 0L;
            }
        });
    }

    public static Long product(Short[] values) {
        return (Long)MathUtils.product((Number[])values, (Multiplicator)new Multiplicator<Short, Long>(){

            @Override
            public Long multiply(Long a, Short b) {
                return a * (long)b.shortValue();
            }

            @Override
            public Long one() {
                return 1L;
            }

            @Override
            public Long zero() {
                return 0L;
            }
        });
    }

    public static Long product(Integer[] values) {
        return (Long)MathUtils.product((Number[])values, (Multiplicator)new Multiplicator<Integer, Long>(){

            @Override
            public Long multiply(Long a, Integer b) {
                return a * (long)b.intValue();
            }

            @Override
            public Long one() {
                return 1L;
            }

            @Override
            public Long zero() {
                return 0L;
            }
        });
    }

    public static Long product(Long[] values) {
        return (Long)MathUtils.product((Number[])values, (Multiplicator)new Multiplicator<Long, Long>(){

            @Override
            public Long multiply(Long a, Long b) {
                return a * b;
            }

            @Override
            public Long one() {
                return 1L;
            }

            @Override
            public Long zero() {
                return 0L;
            }
        });
    }

    public static Float product(Float[] values) {
        return (Float)MathUtils.product((Number[])values, (Multiplicator)new Multiplicator<Float, Float>(){

            @Override
            public Float multiply(Float a, Float b) {
                return Float.valueOf(a.floatValue() * b.floatValue());
            }

            @Override
            public Float one() {
                return Float.valueOf(1.0f);
            }

            @Override
            public Float zero() {
                return Float.valueOf(0.0f);
            }
        });
    }

    public static Double product(Double[] values) {
        return (Double)MathUtils.product((Number[])values, (Multiplicator)new Multiplicator<Double, Double>(){

            @Override
            public Double multiply(Double a, Double b) {
                return a * b;
            }

            @Override
            public Double one() {
                return 1.0;
            }

            @Override
            public Double zero() {
                return 0.0;
            }
        });
    }

    public static BigInteger product(BigInteger[] values) {
        return (BigInteger)MathUtils.product((Number[])values, (Multiplicator)new Multiplicator<BigInteger, BigInteger>(){

            @Override
            public BigInteger multiply(BigInteger a, BigInteger b) {
                return a.multiply(b);
            }

            @Override
            public BigInteger one() {
                return BigInteger.ONE;
            }

            @Override
            public BigInteger zero() {
                return BigInteger.ZERO;
            }
        });
    }

    public static BigDecimal product(BigDecimal[] values) {
        return (BigDecimal)MathUtils.product((Number[])values, (Multiplicator)new Multiplicator<BigDecimal, BigDecimal>(){

            @Override
            public BigDecimal multiply(BigDecimal a, BigDecimal b) {
                return a.multiply(b);
            }

            @Override
            public BigDecimal one() {
                return BigDecimal.ONE;
            }

            @Override
            public BigDecimal zero() {
                return BigDecimal.ZERO;
            }
        });
    }

    public static Long product(byte[] values) {
        if (values == null) {
            return null;
        }
        long res = 1L;
        for (byte a : values) {
            res *= (long)a;
        }
        return values.length > 0 ? res : 0L;
    }

    public static Long product(short[] values) {
        if (values == null) {
            return null;
        }
        long res = 1L;
        for (short a : values) {
            res *= (long)a;
        }
        return values.length > 0 ? res : 0L;
    }

    public static Long product(int[] values) {
        if (values == null) {
            return null;
        }
        long res = 1L;
        for (int a : values) {
            res *= (long)a;
        }
        return values.length > 0 ? res : 0L;
    }

    public static Long product(long[] values) {
        if (values == null) {
            return null;
        }
        long res = 1L;
        for (long a : values) {
            res *= a;
        }
        return values.length > 0 ? res : 0L;
    }

    public static Float product(float[] values) {
        if (values == null) {
            return null;
        }
        float res = 1.0f;
        for (float a : values) {
            res *= a;
        }
        return Float.valueOf(values.length > 0 ? res : 0.0f);
    }

    public static Double product(double[] values) {
        if (values == null) {
            return null;
        }
        double res = 1.0;
        for (double a : values) {
            res *= a;
        }
        return values.length > 0 ? res : 0.0;
    }

    public static <T extends Number> Double median(T[] values) {
        if (values == null) {
            return null;
        }
        if ((values = (Number[])ArrayTool.removeNulls(values)).length == 0) {
            return null;
        }
        double[] doubleArray = MathUtils.numberArrayToDoubleArray(values);
        return MathUtils.median(doubleArray);
    }

    public static Float median(Float[] values) {
        if (values == null) {
            return null;
        }
        if ((values = ArrayTool.removeNulls(values)).length == 0) {
            return null;
        }
        double[] doubleArray = MathUtils.numberArrayToDoubleArray((Number[])values);
        Double median = MathUtils.median(doubleArray);
        if (median == null) {
            return null;
        }
        return Float.valueOf(median.floatValue());
    }

    public static BigInteger median(BigInteger[] values) {
        throw new NotImplementedException(String.format("Method median for %s is not implemented yet", values.getClass().getName()));
    }

    public static BigDecimal median(BigDecimal[] values) {
        throw new NotImplementedException(String.format("Method median for %s is not implemented yet", values.getClass().getName()));
    }

    public static Double median(double[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            return values[0];
        }
        if (length == 2) {
            return (values[0] + values[1]) * 0.5;
        }
        double[] copy = Arrays.copyOf(values, length);
        Arrays.sort(copy);
        int index = --length >> 1;
        if (length % 2 == 0) {
            return copy[index];
        }
        return (copy[index] + copy[index + 1]) * 0.5;
    }

    public static Double median(byte[] values) {
        return MathUtils.median(MathUtils.byteArrayToDoubleArray(values));
    }

    public static Double median(short[] values) {
        return MathUtils.median(MathUtils.shortArrayToDoubleArray(values));
    }

    public static Double median(int[] values) {
        return MathUtils.median(MathUtils.intArrayToDoubleArray(values));
    }

    public static Double median(long[] values) {
        return MathUtils.median(MathUtils.longArrayToDoubleArray(values));
    }

    public static Float median(float[] values) {
        Double median = MathUtils.median(MathUtils.floatArrayToDoubleArray(values));
        if (median == null) {
            return null;
        }
        return Float.valueOf(median.floatValue());
    }

    public static byte mod(byte number, byte divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        byte intPart = (byte)quotient;
        if (quotient < 0L) {
            intPart = (byte)(intPart - 1);
        }
        return (byte)(number - intPart * divisor);
    }

    public static short mod(short number, short divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        short intPart = (short)quotient;
        if (quotient < 0L) {
            intPart = (short)(intPart - 1);
        }
        return (short)(number - intPart * divisor);
    }

    public static int mod(int number, int divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        int intPart = (int)quotient;
        if (quotient < 0L) {
            --intPart;
        }
        return number - intPart * divisor;
    }

    public static long mod(long number, long divisor) {
        long quotient;
        long intPart = quotient = MathUtils.quotient(number, divisor);
        if (quotient < 0L) {
            --intPart;
        }
        return number - intPart * divisor;
    }

    public static float mod(float number, float divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        float intPart = quotient;
        if (quotient < 0L) {
            intPart -= 1.0f;
        }
        return number - intPart * divisor;
    }

    public static double mod(double number, double divisor) {
        long quotient = MathUtils.quotient(number, divisor);
        double intPart = quotient;
        if (quotient < 0L) {
            intPart -= 1.0;
        }
        return number - intPart * divisor;
    }

    public static Byte mod(Byte number, Byte divisor) {
        if (number == null || divisor == null) {
            return Byte.valueOf("0");
        }
        return MathUtils.mod((byte)number, (byte)divisor);
    }

    public static Short mod(Short number, Short divisor) {
        if (number == null || divisor == null) {
            return Short.valueOf("0");
        }
        return MathUtils.mod((short)number, (short)divisor);
    }

    public static Integer mod(Integer number, Integer divisor) {
        if (number == null || divisor == null) {
            return Integer.valueOf("0");
        }
        return MathUtils.mod((int)number, (int)divisor);
    }

    public static Long mod(Long number, Long divisor) {
        if (number == null || divisor == null) {
            return Long.valueOf("0");
        }
        return MathUtils.mod((long)number, (long)divisor);
    }

    public static Float mod(Float number, Float divisor) {
        if (number == null || divisor == null) {
            return Float.valueOf("0");
        }
        return Float.valueOf(MathUtils.mod(number.floatValue(), divisor.floatValue()));
    }

    public static Double mod(Double number, Double divisor) {
        if (number == null || divisor == null) {
            return Double.valueOf("0");
        }
        return MathUtils.mod((double)number, (double)divisor);
    }

    public static BigInteger mod(BigInteger number, BigInteger divisor) {
        long quotient;
        if (number == null || divisor == null) {
            return BigInteger.ZERO;
        }
        long intPart = quotient = MathUtils.quotient(number, divisor);
        if (quotient < 0L) {
            --intPart;
        }
        return number.subtract(BigInteger.valueOf(intPart).multiply(divisor));
    }

    public static BigDecimal mod(BigDecimal number, BigDecimal divisor) {
        long quotient;
        if (number == null || divisor == null) {
            return BigDecimal.ZERO;
        }
        long intPart = quotient = MathUtils.quotient(number, divisor);
        if (quotient < 0L) {
            --intPart;
        }
        return number.subtract(BigDecimal.valueOf(intPart).multiply(divisor));
    }

    public static long quotient(byte number, byte divisor) {
        return number / divisor;
    }

    public static long quotient(short number, short divisor) {
        return number / divisor;
    }

    public static long quotient(int number, int divisor) {
        return number / divisor;
    }

    public static long quotient(long number, long divisor) {
        return number / divisor;
    }

    public static long quotient(float number, float divisor) {
        return (long)(number / divisor);
    }

    public static long quotient(double number, double divisor) {
        return (long)(number / divisor);
    }

    public static long quotient(Byte number, Byte divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((byte)number, (byte)divisor);
    }

    public static long quotient(Short number, Short divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((short)number, (short)divisor);
    }

    public static long quotient(Integer number, Integer divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((int)number, (int)divisor);
    }

    public static long quotient(Long number, Long divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((long)number, (long)divisor);
    }

    public static long quotient(Float number, Float divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient(number.floatValue(), divisor.floatValue());
    }

    public static long quotient(Double number, Double divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.quotient((double)number, (double)divisor);
    }

    public static long quotient(BigInteger number, BigInteger divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.divide(number, divisor).longValue();
    }

    public static long quotient(BigDecimal number, BigDecimal divisor) {
        if (number == null || divisor == null) {
            return 0L;
        }
        return MathUtils.divide(number, divisor).longValue();
    }

    public static <T extends Comparable<?>> T[] sort(T[] values) {
        if (values != null) {
            Arrays.sort(values);
        }
        return values;
    }

    public static byte[] sort(byte[] values) {
        if (values != null) {
            Arrays.sort(values);
        }
        return values;
    }

    public static short[] sort(short[] values) {
        if (values != null) {
            Arrays.sort(values);
        }
        return values;
    }

    public static int[] sort(int[] values) {
        if (values != null) {
            Arrays.sort(values);
        }
        return values;
    }

    public static long[] sort(long[] values) {
        if (values != null) {
            Arrays.sort(values);
        }
        return values;
    }

    public static float[] sort(float[] values) {
        if (values != null) {
            Arrays.sort(values);
        }
        return values;
    }

    public static double[] sort(double[] values) {
        if (values != null) {
            Arrays.sort(values);
        }
        return values;
    }

    public static BigDecimal divide(BigDecimal number, BigDecimal divisor) {
        if (number == null || divisor == null) {
            return null;
        }
        return number.divide(divisor, MathContext.DECIMAL128);
    }

    public static BigInteger divide(BigInteger number, BigInteger divisor) {
        if (number == null || divisor == null) {
            return null;
        }
        return number.divide(divisor);
    }

    private static interface Multiplicator<T extends Number, R extends Number> {
        public R multiply(R var1, T var2);

        public R one();

        public R zero();
    }

    private static interface Adder<T extends Number> {
        public T add(T var1, T var2);

        public T zero();
    }
}

