/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.print;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.openl.util.StringTool;
import org.openl.util.print.DoublePrinter;
import org.openl.util.print.NicePrinter;

public class NicePrinterAdaptor {
    static Class<?>[] primitiveClasses = new Class[]{Integer.class, Double.class, Boolean.class, Character.class, Float.class, Byte.class, Long.class, Short.class, String.class, Date.class};
    public static final Comparator<Map.Entry<Object, Object>> mapComparator = new MapEntryComparator<Object, Object>();

    public static boolean isPrimitiveClass(Class<?> c) {
        for (int i = 0; i < primitiveClasses.length; ++i) {
            if (primitiveClasses[i] != c) continue;
            return true;
        }
        return false;
    }

    public static String shortTypeName(String classname) {
        int idx = classname.lastIndexOf(46);
        return idx < 0 ? classname : classname.substring(idx + 1);
    }

    public NicePrinterAdaptor getAdaptor(Object obj) {
        return this;
    }

    public Object getProperty(Object obj, String propertyName) {
        try {
            Method m = obj.getClass().getMethod(StringTool.getGetterName(propertyName), new Class[0]);
            String res = (String)m.invoke(obj, new Object[0]);
            return res;
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected String getTypeName(Object obj) {
        return obj.getClass().getName();
    }

    public Object getUniqueID(Object obj) {
        Object id = this.getProperty(obj, "name");
        if (id == null) {
            id = this.getProperty(obj, "id");
        }
        return id;
    }

    public boolean isPrimitive(Object obj) {
        return NicePrinterAdaptor.isPrimitiveClass(obj.getClass());
    }

    public void printArray(Object ary, int newID, NicePrinter printer) {
        int len = Array.getLength(ary);
        if (len == 0) {
            printer.getBuffer().append("[]");
            return;
        }
        printer.getBuffer().append('{');
        printer.incIdent();
        for (int i = 0; i < len; ++i) {
            printer.startNewLine();
            printer.getBuffer().append('[').append(i).append("]=");
            printer.print(Array.get(ary, i), this);
        }
        printer.startNewLine();
        printer.getBuffer().append('}');
        printer.decIdent();
    }

    public void printCollection(Collection<?> c, int newID, NicePrinter printer) {
        Object[] ary = new Object[c.size()];
        Iterator<?> it = c.iterator();
        int i = 0;
        while (it.hasNext()) {
            ary[i] = it.next();
            ++i;
        }
        this.printArray(ary, newID, printer);
    }

    public void printMap(Map map, Comparator<Map.Entry<Object, Object>> mapEntryComparator, NicePrinter printer) {
        int len = map.size();
        if (len == 0) {
            printer.getBuffer().append("[]");
            return;
        }
        Map.Entry[] entries = new Map.Entry[len];
        Iterator it = map.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            entries[i] = it.next();
            ++i;
        }
        if (mapEntryComparator == null) {
            mapEntryComparator = mapComparator;
        }
        Arrays.sort(entries, mapEntryComparator);
        printer.getBuffer().append('{');
        printer.incIdent();
        for (i = 0; i < len; ++i) {
            printer.startNewLine();
            printer.getBuffer().append(entries[i].getKey()).append("=");
            printer.print(entries[i].getValue(), this);
        }
        printer.startNewLine();
        printer.getBuffer().append('}');
        printer.decIdent();
    }

    public void printNull(NicePrinter printer) {
        printer.getBuffer().append("null");
    }

    public void printObject(Object obj, int newID, NicePrinter printer) {
        printer.getBuffer().append(obj);
    }

    public void printPrimitive(Object obj, NicePrinter printer) {
        if (obj.getClass() == Double.class) {
            printer.getBuffer().append(DoublePrinter.printDouble((Double)obj));
        } else {
            printer.getBuffer().append(obj);
        }
    }

    public void printReference(Object obj, int id, NicePrinter printer) {
        printer.getBuffer().append(NicePrinterAdaptor.shortTypeName(this.getTypeName(obj)));
        Object objID = this.getUniqueID(obj);
        if (objID == null) {
            objID = String.valueOf(id);
        }
        printer.getBuffer().append('(').append("id=").append(objID).append(')');
    }

    static class MapEntryComparator<K, V>
    implements Comparator<Map.Entry<K, V>> {
        MapEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
            String key1 = String.valueOf(e1.getKey());
            String key2 = String.valueOf(e2.getKey());
            if (key1.equals("id")) {
                return -1;
            }
            if (key2.equals("id")) {
                return 1;
            }
            if (key1.equals("name")) {
                return -1;
            }
            if (key2.equals("name")) {
                return 1;
            }
            return key1.compareTo(key2);
        }
    }
}

