/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.trie;

import java.util.Iterator;
import org.openl.util.trie.CharSequenceKey;
import org.openl.util.trie.DepthFirstNodeIterator;
import org.openl.util.trie.IARTNode;
import org.openl.util.trie.IARTNodeN;
import org.openl.util.trie.IARTNodeV;
import org.openl.util.trie.IARTreeBase;
import org.openl.util.trie.ISequentialKey;
import org.openl.util.trie.nodes.ARTNode1NbVib;

public final class ARTree1<V>
implements IARTreeBase<V> {
    IARTNode root;

    public ARTree1() {
        this(ARTree1.defaultRange());
    }

    public ARTree1(ISequentialKey.KeyRange rootRange) {
        this.root = this.createNode(rootRange);
    }

    private IARTNode createNode(ISequentialKey.KeyRange range) {
        return new ARTNode1NbVib();
    }

    private static ISequentialKey.KeyRange defaultRange() {
        return CharSequenceKey.UTF8RangeKey;
    }

    @Override
    public void put(ISequentialKey key, V value) {
        this.root = this.insert(this.root, key, value, 0);
    }

    private IARTNode insert(IARTNode current, ISequentialKey key, V value, int depth) {
        int len = key.length();
        if (depth == len - 1) {
            return this.insertValue(current, key, value);
        }
        int index = key.keyAt(depth);
        IARTNode next = current.findNode(index);
        if (next != null) {
            IARTNode next1 = this.insert(next, key, value, depth + 1);
            if (next1 != next) {
                current.setNode(index, next1);
            }
            return current;
        }
        next = this.createNext(key, depth);
        next = this.insert(next, key, value, depth + 1);
        current.setNode(index, next);
        return current;
    }

    private IARTNode createNext(ISequentialKey key, int depth) {
        return new ARTNode1NbVib();
    }

    private IARTNode insertValue(IARTNodeV current, ISequentialKey key, V value) {
        int index = key.keyAt(key.length() - 1);
        current.setValue(index, value);
        return (IARTNode)current;
    }

    @Override
    public V get(ISequentialKey key) {
        int len = key.length() - 1;
        IARTNode current = this.root;
        for (int depth = 0; depth < len; ++depth) {
            int index = key.keyAt(depth);
            IARTNode next = ((IARTNodeN)current).findNode(index);
            if (next == null) {
                return null;
            }
            current = next;
        }
        Object res = ((IARTNodeV)current).getValue(key.keyAt(len));
        return (V)res;
    }

    @Override
    public void compact() {
        this.root = this.root.compact();
    }

    @Override
    public Iterator<IARTNode> nodeIteratorDepthFirst() {
        return new DepthFirstNodeIterator(this.root);
    }
}

