/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.trie;

import java.util.Iterator;
import org.openl.util.trie.CharSequenceKey;
import org.openl.util.trie.DepthFirstNodeIterator;
import org.openl.util.trie.IARTNode;
import org.openl.util.trie.IARTreeBase;
import org.openl.util.trie.ISequentialKey;
import org.openl.util.trie.nodes.ARTNode1NbVib;

public final class ARTree2<V>
implements IARTreeBase<V> {
    IARTNode root;

    public ARTree2() {
        this(ARTree2.defaultRange());
    }

    public ARTree2(ISequentialKey.KeyRange rootRange) {
        this.root = this.createNode(rootRange);
    }

    private IARTNode createNode(ISequentialKey.KeyRange range) {
        return new ARTNode1NbVib();
    }

    private static ISequentialKey.KeyRange defaultRange() {
        return CharSequenceKey.UTF8RangeKey;
    }

    @Override
    public void put(ISequentialKey key, V value) {
        IARTNode current = this.root;
        int len = key.length() - 1;
        for (int depth = 0; depth < len; ++depth) {
            int index = key.keyAt(depth);
            IARTNode next = current.findNode(index);
            if (next != null) {
                current = next;
                continue;
            }
            next = new ARTNode1NbVib();
            current.setNode(index, next);
            current = next;
        }
        current.setValue(key.keyAt(len), value);
    }

    protected IARTNode createNext(ISequentialKey key, int depth) {
        ISequentialKey.KeyRange range = key.keyRange(depth);
        return this.createNode(range);
    }

    @Override
    public V get(ISequentialKey key) {
        int len = key.length() - 1;
        IARTNode current = this.root;
        for (int depth = 0; depth < len; ++depth) {
            if ((current = current.findNode(key.keyAt(depth))) != null) continue;
            return null;
        }
        return (V)current.getValue(key.keyAt(len));
    }

    @Override
    public void compact() {
        this.root = this.root.compact();
    }

    @Override
    public Iterator<IARTNode> nodeIteratorDepthFirst() {
        return new DepthFirstNodeIterator(this.root);
    }
}

