/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.trie;

import java.util.Collections;
import java.util.Iterator;
import org.openl.util.trie.CharSequenceKey;
import org.openl.util.trie.DepthFirstNodeIterator;
import org.openl.util.trie.IARPrefixTree;
import org.openl.util.trie.IARTNode;
import org.openl.util.trie.IARTree;
import org.openl.util.trie.ISequentialKey;
import org.openl.util.trie.ValueArrayIterator;
import org.openl.util.trie.nodes.ARTNode1NbVib;

public final class ARTree3<V>
implements IARPrefixTree<V>,
IARTree<V> {
    IARTNode root;

    public ARTree3() {
        this(ARTree3.defaultRange());
    }

    public ARTree3(ISequentialKey.KeyRange rootRange) {
        this.root = this.createNode(rootRange);
    }

    private IARTNode createNode(ISequentialKey.KeyRange range) {
        return new ARTNode1NbVib();
    }

    private static ISequentialKey.KeyRange defaultRange() {
        return CharSequenceKey.UTF8RangeKey;
    }

    @Override
    public void put(CharSequence key, V value) {
        IARTNode current = this.root;
        int len = key.length() - 1;
        for (int depth = 0; depth < len; ++depth) {
            char index = key.charAt(depth);
            IARTNode next = current.findNode(index);
            if (next != null) {
                current = next;
                continue;
            }
            next = new ARTNode1NbVib();
            current.setNode(index, next);
            current = next;
        }
        current.setValue(key.charAt(len), value);
    }

    @Override
    public V get(CharSequence key) {
        int len = key.length() - 1;
        IARTNode current = this.root;
        for (int depth = 0; depth < len; ++depth) {
            if ((current = current.findNode(key.charAt(depth))) != null) continue;
            return null;
        }
        return (V)current.getValue(key.charAt(len));
    }

    @Override
    public void compact() {
        this.root = this.root.compact();
    }

    @Override
    public Iterator<IARTNode> nodeIteratorDepthFirst() {
        return new DepthFirstNodeIterator(this.root);
    }

    @Override
    public void put(ISequentialKey key, V value) {
        IARTNode current = this.root;
        int len = key.length() - 1;
        for (int depth = 0; depth < len; ++depth) {
            int index = key.keyAt(depth);
            IARTNode next = current.findNode(index);
            if (next != null) {
                current = next;
                continue;
            }
            next = new ARTNode1NbVib();
            current.setNode(index, next);
            current = next;
        }
        current.setValue(key.keyAt(len), value);
    }

    @Override
    public V get(ISequentialKey key) {
        int len = key.length() - 1;
        IARTNode current = this.root;
        for (int depth = 0; depth < len; ++depth) {
            if ((current = current.findNode(key.keyAt(depth))) != null) continue;
            return null;
        }
        return (V)current.getValue(key.keyAt(len));
    }

    @Override
    public Iterator<V> allPrefixesOf(ISequentialKey key) {
        int len = key.length() - 1;
        if (len < 0) {
            return Collections.emptyList().iterator();
        }
        Object[] ary = new Object[len + 1];
        int maxNode = -1;
        IARTNode current = this.root;
        for (int depth = 0; depth < len; ++depth) {
            int index = key.keyAt(depth);
            Object x = current.getValue(index);
            if (x != null) {
                maxNode = depth;
                ary[depth] = x;
            }
            if ((current = current.findNode(index)) != null) continue;
            return new ValueArrayIterator(ary, maxNode);
        }
        Object x = current.getValue(key.keyAt(len));
        if (x != null) {
            ary[len] = x;
            maxNode = len;
        }
        return new ValueArrayIterator(ary, maxNode);
    }

    @Override
    public V getLongestPrefixValue(ISequentialKey key) {
        int len = key.length() - 1;
        Object ret = null;
        IARTNode current = this.root;
        for (int depth = 0; depth < len; ++depth) {
            int index = key.keyAt(depth);
            Object x = current.getValue(index);
            if (x != null) {
                ret = x;
            }
            if ((current = current.findNode(index)) != null) continue;
            return (V)ret;
        }
        Object x = current.getValue(key.keyAt(len));
        return (V)(x != null ? x : ret);
    }

    @Override
    public V getLongestPrefixValue(CharSequence key) {
        int len = key.length() - 1;
        Object ret = null;
        IARTNode current = this.root;
        for (int depth = 0; depth < len; ++depth) {
            char index = key.charAt(depth);
            Object x = current.getValue(index);
            if (x != null) {
                ret = x;
            }
            if ((current = current.findNode(index)) != null) continue;
            return (V)ret;
        }
        Object x = current.getValue(key.charAt(len));
        return (V)(x != null ? x : ret);
    }

    @Override
    public Iterator<V> allPrefixesOf(CharSequence key) {
        int len = key.length() - 1;
        if (len < 0) {
            return Collections.emptyList().iterator();
        }
        Object[] ary = new Object[len + 1];
        int maxNode = -1;
        IARTNode current = this.root;
        for (int depth = 0; depth < len; ++depth) {
            char index = key.charAt(depth);
            Object x = current.getValue(index);
            if (x != null) {
                maxNode = depth;
                ary[depth] = x;
            }
            if ((current = current.findNode(index)) != null) continue;
            return new ValueArrayIterator(ary, maxNode);
        }
        Object x = current.getValue(key.charAt(len));
        if (x != null) {
            ary[len] = x;
            maxNode = len;
        }
        return new ValueArrayIterator(ary, maxNode);
    }
}

