/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.trie.cnodes;

import org.openl.domain.IIntIterator;
import org.openl.util.trie.IARTNode;
import org.openl.util.trie.IARTNodeV;
import org.openl.util.trie.nodes.MappedArrayIterator;

public class ARTNode1NbC
extends IARTNodeV.EmptyARTNodeV
implements IARTNode {
    int startN;
    byte[] mapperN;
    IARTNode[] nodes;

    public ARTNode1NbC(int startN, byte[] mapperN, IARTNode[] nodes) {
        this.startN = startN;
        this.nodes = nodes;
        this.mapperN = mapperN;
    }

    @Override
    public IARTNode findNode(int index) {
        int idx = index - this.startN;
        if (idx < 0 || idx >= this.mapperN.length) {
            return null;
        }
        byte b = this.mapperN[idx];
        if (b == 0) {
            return null;
        }
        return this.nodes[255 - b & 0xFF];
    }

    @Override
    public void setNode(int index, IARTNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int countN() {
        return this.nodes.length;
    }

    @Override
    public int minIndexN() {
        return this.startN;
    }

    @Override
    public int maxIndexN() {
        return this.startN + this.nodes.length - 1;
    }

    @Override
    public IIntIterator indexIteratorN() {
        return MappedArrayIterator.iterator(this.startN, this.mapperN);
    }

    @Override
    public IARTNode compact() {
        return this;
    }
}

