/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.trie.ex;

import org.openl.util.trie.ex.ARTNodeOld;

public class AdaptiveRadixTree {
    public static final int MAX_BYTE_NODE_SIZE = 256;
    private boolean usePrefix = false;
    private int[] maxNodeSizes;

    public AdaptiveRadixTree(boolean usePrefix, int[] maxNodeSizes) {
        this.usePrefix = usePrefix;
        this.maxNodeSizes = maxNodeSizes;
    }

    public int getMaxNodeSize(int depth) {
        return this.maxNodeSizes == null || this.maxNodeSizes.length <= depth ? 256 : this.maxNodeSizes[depth];
    }

    public ARTNodeOld search(ARTNodeOld node, byte[] key, int depth) {
        if (node == null) {
            return null;
        }
        if (this.isLeaf(node)) {
            if (this.leafMatches(node, key, depth)) {
                return node;
            }
            return null;
        }
        if (this.usePrefix) {
            if (this.checkPrefix(node, key, depth) != node.prefixLen()) {
                return null;
            }
            depth += node.prefixLen();
        }
        ARTNodeOld next = node.findChild(key[depth]);
        return this.search(next, key, depth + 1);
    }

    private int checkPrefix(ARTNodeOld node, byte[] key, int depth) {
        if (!this.usePrefix) {
            return 0;
        }
        throw new UnsupportedOperationException("Use Prefix");
    }

    private boolean leafMatches(ARTNodeOld node, byte[] key, int depth) {
        return false;
    }

    ARTNodeOld insert(ARTNodeOld node, byte[] key, int depth, int value) {
        ARTNodeOld newNode;
        byte byteKey = key[depth];
        ARTNodeOld next = node.findChild(byteKey);
        if (next == null) {
            next = this.createNewNode(key, depth + 1, value);
            if (node.isFull()) {
                node = this.grow(node);
            }
            node.addChild(next, byteKey, value);
        }
        if ((newNode = this.insert(next, key, depth + 1, value)) != next) {
            node.replace(newNode, byteKey);
        }
        return node;
    }

    private ARTNodeOld createNewNode(byte[] key, int depth, int value) {
        return null;
    }

    private ARTNodeOld grow(ARTNodeOld node) {
        return null;
    }

    private byte[] loadKey(ARTNodeOld node) {
        return null;
    }

    private boolean isLeaf(ARTNodeOld node) {
        return false;
    }
}

