/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.trie.nodes;

import org.openl.domain.IIntIterator;
import org.openl.util.trie.IARTNode;
import org.openl.util.trie.IARTNodeVi;
import org.openl.util.trie.cnodes.ARTNode1N;
import org.openl.util.trie.cnodes.ARTNode1NViC;
import org.openl.util.trie.cnodes.ARTNode1NVibC;
import org.openl.util.trie.cnodes.ARTNode1NbC;
import org.openl.util.trie.cnodes.ARTNode1NbViC;
import org.openl.util.trie.cnodes.ARTNode1NbVibC;
import org.openl.util.trie.cnodes.ARTNode1Vi;
import org.openl.util.trie.cnodes.ARTNode1VibC;
import org.openl.util.trie.cnodes.CNodeFactory;
import org.openl.util.trie.cnodes.SingleNodeN;
import org.openl.util.trie.cnodes.SingleNodeVi;
import org.openl.util.trie.nodes.MappedArrayIterator;

public final class ARTNode1NbVib
implements IARTNode,
IARTNodeVi {
    private static final int MAXIMUM_CAPACITY = 255;
    int startN;
    IARTNode[] nodes;
    byte[] mapperN;
    private int countN = 0;
    private int minIndexN;
    private int maxIndexN;
    int startV;
    int[] values;
    byte[] mapperV;
    private int countV = 0;
    private int minIndexV;
    private int maxIndexV;

    protected void initN(int start, int capacity, int mapCapacity) {
        this.nodes = new IARTNode[capacity];
        this.mapperN = new byte[mapCapacity];
        this.startN = start;
        this.minIndexN = start + mapCapacity;
        this.maxIndexN = start;
    }

    @Override
    public IARTNode findNode(int index) {
        if (this.mapperN == null) {
            return null;
        }
        int idx = index - this.startN;
        if (idx < 0 || idx >= this.mapperN.length) {
            return null;
        }
        byte b = this.mapperN[idx];
        if (b == 0) {
            return null;
        }
        return this.nodes[255 - b & 0xFF];
    }

    @Override
    public void setNode(int index, IARTNode node) {
        int idx;
        if (this.mapperN == null) {
            this.initN(index);
        }
        if ((idx = index - this.startN) < 0) {
            this.growNodeDownN(index);
            this.setNode(index, node);
            return;
        }
        if (idx >= this.mapperN.length) {
            this.growMapperUpN(index);
            this.setNode(index, node);
            return;
        }
        if (this.mapperN[idx] == 0) {
            if (this.countN >= this.nodes.length) {
                this.growCapacityN();
                this.setNode(index, node);
                return;
            }
            this.minIndexN = Math.min(index, this.minIndexN);
            this.maxIndexN = Math.max(index, this.maxIndexN);
            this.nodes[this.countN++] = node;
            this.mapperN[idx] = (byte)(256 - this.countN);
        } else {
            byte b = this.mapperN[idx];
            this.nodes[255 - b & 0xFF] = node;
        }
    }

    private void initN(int index) {
        if (97 <= index && index <= 122) {
            this.initN(97, 10, 26);
        } else if (65 <= index && index <= 90) {
            this.initN(65, 10, 26);
        } else if (48 <= index && index <= 57) {
            this.initN(48, 5, 10);
        } else {
            int startX = Math.max(index - 10, 0);
            this.initN(startX, 10, 40);
        }
    }

    private void growCapacityN() {
        int oldCapacity = this.nodes.length;
        int newCapacity = this.newCapacityN(oldCapacity * 2);
        if (newCapacity <= oldCapacity) {
            throw new RuntimeException("Node capacity overflow");
        }
        IARTNode[] newNodes = new IARTNode[newCapacity];
        System.arraycopy(this.nodes, 0, newNodes, 0, oldCapacity);
        this.nodes = newNodes;
    }

    private void growMapperUpN(int index) {
        int newRequiredCapacity = index - this.minIndexN + 1;
        int oldCapacity = this.mapperN.length;
        if (newRequiredCapacity <= oldCapacity) {
            int margin = (oldCapacity - newRequiredCapacity) / 2;
            int newStart = this.minIndexN - margin;
            int shift = newStart - this.startN;
            int oldOrigin = this.minIndexN - this.startN;
            int oldSize = this.maxIndexN - this.minIndexN + 1;
            System.arraycopy(this.mapperN, oldOrigin, this.mapperN, margin, oldSize);
            int cleanSize = Math.min(shift, oldSize);
            for (int i = 0; i < cleanSize; ++i) {
                this.mapperN[this.maxIndexN - this.startN - i] = 0;
            }
            this.startN = newStart;
            return;
        }
        int newCapacity = this.newCapacityN(Math.max(oldCapacity * 2, newRequiredCapacity));
        if (newCapacity < newRequiredCapacity) {
            throw new RuntimeException("Node capacity Overflow");
        }
        byte[] newMapper = new byte[newCapacity];
        int margin = (newCapacity - newRequiredCapacity) / 2;
        int newStart = this.minIndexN - margin;
        int oldMargin = this.minIndexN - this.startN;
        int oldSize = this.maxIndexN - this.minIndexN + 1;
        System.arraycopy(this.mapperN, oldMargin, newMapper, margin, oldSize);
        this.startN = newStart;
        this.mapperN = newMapper;
    }

    private void growNodeDownN(int index) {
        int oldCapacity = this.mapperN.length;
        int newRequiredCapacity = this.maxIndexN - index + 1;
        int margin = (oldCapacity - newRequiredCapacity) / 2;
        int newStart = index - margin;
        int shift = this.startN - newStart;
        int oldOrigin = this.minIndexN - this.startN;
        int newOrigin = oldOrigin + shift;
        int oldSize = this.maxIndexN - this.minIndexN + 1;
        if (newRequiredCapacity <= oldCapacity) {
            System.arraycopy(this.mapperN, oldOrigin, this.mapperN, newOrigin, oldSize);
            int cleanSize = Math.min(shift, oldSize);
            for (int i = 0; i < cleanSize; ++i) {
                this.mapperN[oldOrigin + i] = 0;
            }
            this.startN = newStart;
            return;
        }
        int newCapacity = this.newCapacityN(Math.max(oldCapacity * 2, newRequiredCapacity));
        if (newCapacity < newRequiredCapacity) {
            throw new RuntimeException("Node capacity Overflow");
        }
        byte[] newMapper = new byte[newCapacity];
        margin = (newCapacity - newRequiredCapacity) / 2;
        newStart = this.minIndexN - margin;
        shift = this.startN - newStart;
        newOrigin = oldOrigin + shift;
        System.arraycopy(this.mapperN, oldOrigin, newMapper, newOrigin, oldSize);
        this.startN = newStart;
        this.mapperN = newMapper;
    }

    protected int newCapacityN(int required) {
        if (required < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + required);
        }
        if (required > 255) {
            required = 255;
        }
        return required;
    }

    @Override
    public int countN() {
        return this.countN;
    }

    @Override
    public int minIndexN() {
        return this.minIndexN;
    }

    @Override
    public int maxIndexN() {
        return this.maxIndexN;
    }

    @Override
    public IIntIterator indexIteratorN() {
        return MappedArrayIterator.iterator(this.startN, this.mapperN);
    }

    protected void initV(int start, int capacity, int mapCapacity) {
        this.values = new int[capacity];
        this.mapperV = new byte[mapCapacity];
        this.startV = start;
        this.minIndexV = start + mapCapacity;
        this.maxIndexV = start;
    }

    @Override
    public Object getValue(int index) {
        if (this.mapperV == null) {
            return null;
        }
        int idx = index - this.startV;
        if (idx < 0 || idx >= this.mapperV.length) {
            return null;
        }
        byte b = this.mapperV[idx];
        if (b == 0) {
            return null;
        }
        return this.values[255 - b & 0xFF];
    }

    @Override
    public void setValue(int index, Object value) {
        int idx;
        if (this.mapperV == null) {
            this.initV(index);
        }
        if ((idx = index - this.startV) < 0) {
            this.growNodeDownV(index);
            this.setValue(index, value);
            return;
        }
        if (idx >= this.mapperV.length) {
            this.growMapperUpV(index);
            this.setValue(index, value);
            return;
        }
        if (this.mapperV[idx] == 0) {
            if (this.countV >= this.values.length) {
                this.growCapacityV();
                this.setValue(index, value);
                return;
            }
            this.minIndexV = Math.min(index, this.minIndexV);
            this.maxIndexV = Math.max(index, this.maxIndexV);
            this.values[this.countV++] = (Integer)value;
            this.mapperV[idx] = (byte)(256 - this.countV);
        } else {
            byte b = this.mapperV[idx];
            this.values[255 - b & 0xFF] = (Integer)value;
        }
    }

    private void initV(int index) {
        if (97 <= index && index <= 122) {
            this.initV(97, 10, 26);
        } else if (65 <= index && index <= 90) {
            this.initV(65, 10, 26);
        } else if (48 <= index && index <= 57) {
            this.initV(48, 5, 10);
        } else {
            int startX = Math.max(index - 10, 0);
            this.initV(startX, 10, 40);
        }
    }

    private void growCapacityV() {
        int oldCapacity = this.values.length;
        int newCapacity = this.newCapacityV(oldCapacity * 2);
        if (newCapacity <= oldCapacity) {
            throw new RuntimeException("Node capacity overflow");
        }
        int[] newValues = new int[newCapacity];
        System.arraycopy(this.values, 0, newValues, 0, oldCapacity);
        this.values = newValues;
    }

    private void growMapperUpV(int index) {
        int newRequiredCapacity = index - this.minIndexV + 1;
        int oldCapacity = this.mapperV.length;
        if (newRequiredCapacity <= oldCapacity) {
            int margin = (oldCapacity - newRequiredCapacity) / 2;
            int newStart = this.minIndexV - margin;
            int shift = newStart - this.startV;
            int oldOrigin = this.minIndexV - this.startV;
            int oldSize = this.maxIndexV - this.minIndexV + 1;
            System.arraycopy(this.mapperV, oldOrigin, this.mapperV, margin, oldSize);
            int cleanSize = Math.min(shift, oldSize);
            for (int i = 0; i < cleanSize; ++i) {
                this.mapperV[this.maxIndexV - this.startV - i] = 0;
            }
            this.startV = newStart;
            return;
        }
        int newCapacity = this.newCapacityV(Math.max(oldCapacity * 2, newRequiredCapacity));
        if (newCapacity < newRequiredCapacity) {
            throw new RuntimeException("Node capacity Overflow");
        }
        byte[] newMapper = new byte[newCapacity];
        int margin = (newCapacity - newRequiredCapacity) / 2;
        int newStart = this.minIndexV - margin;
        int oldMargin = this.minIndexV - this.startV;
        int oldSize = this.maxIndexV - this.minIndexV + 1;
        System.arraycopy(this.mapperV, oldMargin, newMapper, margin, oldSize);
        this.startV = newStart;
        this.mapperV = newMapper;
    }

    private void growNodeDownV(int index) {
        int oldCapacity = this.mapperV.length;
        int newRequiredCapacity = this.maxIndexV - index + 1;
        int margin = (oldCapacity - newRequiredCapacity) / 2;
        int newStart = index - margin;
        int shift = this.startV - newStart;
        int oldOrigin = this.minIndexV - this.startV;
        int newOrigin = oldOrigin + shift;
        int oldSize = this.maxIndexV - this.minIndexV + 1;
        if (newRequiredCapacity <= oldCapacity) {
            System.arraycopy(this.mapperV, oldOrigin, this.mapperV, newOrigin, oldSize);
            int cleanSize = Math.min(shift, oldSize);
            for (int i = 0; i < cleanSize; ++i) {
                this.mapperV[oldOrigin + i] = 0;
            }
            this.startV = newStart;
            return;
        }
        int newCapacity = this.newCapacityV(Math.max(oldCapacity * 2, newRequiredCapacity));
        if (newCapacity < newRequiredCapacity) {
            throw new RuntimeException("Node capacity Overflow");
        }
        byte[] newMapper = new byte[newCapacity];
        margin = (newCapacity - newRequiredCapacity) / 2;
        newStart = this.minIndexV - margin;
        shift = this.startV - newStart;
        newOrigin = oldOrigin + shift;
        System.arraycopy(this.mapperV, oldOrigin, newMapper, newOrigin, oldSize);
        this.startV = newStart;
        this.mapperV = newMapper;
    }

    public int newCapacityV(int required) {
        if (required < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + required);
        }
        if (required > 255) {
            required = 255;
        }
        return required;
    }

    @Override
    public int countV() {
        return this.countV;
    }

    @Override
    public int minIndexV() {
        return this.minIndexV;
    }

    @Override
    public int maxIndexV() {
        return this.maxIndexV;
    }

    @Override
    public IIntIterator indexIteratorV() {
        return MappedArrayIterator.iterator(this.startV, this.mapperV);
    }

    private IARTNode compactX() {
        int newStartN;
        int rangeN = this.maxIndexN - this.minIndexN + 1;
        boolean useMapperN = CNodeFactory.useMapper(rangeN, byte[].class, this.countN, Object[].class);
        int rangeV = this.maxIndexV - this.minIndexV + 1;
        boolean useMapperV = CNodeFactory.useMapper(rangeV, byte[].class, this.countV, int[].class);
        if (!useMapperN) {
            IARTNode[] arrayN = this.makeArrayN(rangeN);
            if (!useMapperV) {
                int[] arrayV = this.makeArrayVi(rangeV);
                return new ARTNode1NViC(this.minIndexN, this.countN, arrayN, this.minIndexV, this.countV, arrayV);
            }
            int[] mappedArrayV = this.makeMappedArrayVi();
            byte[] newMapperV = this.makeMapperV(rangeV);
            int newStartV = newMapperV == this.mapperV ? this.startV : this.minIndexV;
            return new ARTNode1NVibC(this.minIndexN, this.countN, arrayN, newStartV, newMapperV, mappedArrayV);
        }
        IARTNode[] mappedArrayN = this.makeMappedArrayN();
        byte[] newMapperN = this.makeMapperN(rangeN);
        int n = newStartN = this.mapperN == newMapperN ? this.startN : this.minIndexN;
        if (!useMapperV) {
            int[] arrayV = this.makeArrayVi(rangeV);
            return new ARTNode1NbViC(newStartN, newMapperN, mappedArrayN, this.minIndexV, this.countV, arrayV);
        }
        int[] mappedArrayV = this.makeMappedArrayVi();
        byte[] newMapperV = this.makeMapperV(rangeV);
        int newStartV = newMapperV == this.mapperV ? this.startV : this.minIndexV;
        return new ARTNode1NbVibC(newStartN, newMapperN, mappedArrayN, newStartV, newMapperV, mappedArrayV);
    }

    public IARTNode compactN() {
        switch (this.countN) {
            case 1: {
                return new SingleNodeN(this.minIndexN, this.nodes[0].compact());
            }
        }
        int range = this.maxIndexN - this.minIndexN + 1;
        boolean useMapper = CNodeFactory.useMapper(range, byte[].class, this.countN, Object[].class);
        if (useMapper) {
            return this.makeMappedCompactN(range);
        }
        return this.makeArrayCompactN(range);
    }

    private IARTNode makeArrayCompactN(int range) {
        return new ARTNode1N(this.minIndexN, this.countN, this.makeArrayN(range));
    }

    private final IARTNode[] makeArrayN(int rangeN) {
        IARTNode[] res = new IARTNode[rangeN];
        for (int i = this.minIndexN; i <= this.maxIndexN; ++i) {
            byte b = this.mapperN[i - this.startN];
            if (b == 0) continue;
            res[i - this.minIndexN] = this.nodes[255 - b & 0xFF].compact();
        }
        return res;
    }

    private IARTNode[] makeMappedArrayN() {
        IARTNode[] newNodes = new IARTNode[this.countN];
        for (int i = 0; i < newNodes.length; ++i) {
            newNodes[i] = this.nodes[i].compact();
        }
        return newNodes;
    }

    private byte[] makeMapperN(int rangeN) {
        byte[] newMapper = this.mapperN;
        if ((rangeN + 7 & 0xF8) < this.mapperN.length) {
            newMapper = new byte[rangeN];
            System.arraycopy(this.mapperN, this.minIndexN - this.startN, newMapper, 0, rangeN);
        }
        return newMapper;
    }

    private IARTNode makeMappedCompactN(int range) {
        byte[] newMapper = this.makeMapperN(range);
        int newStartN = newMapper == this.mapperN ? this.startN : this.minIndexN;
        IARTNode[] newNodes = this.makeMappedArrayN();
        return new ARTNode1NbC(newStartN, newMapper, newNodes);
    }

    public IARTNode compactV() {
        switch (this.countV) {
            case 1: {
                return new SingleNodeVi(this.minIndexV, this.values[0]);
            }
        }
        int range = this.maxIndexV - this.minIndexV + 1;
        boolean useMapper = CNodeFactory.useMapper(range, byte[].class, this.countV, int[].class);
        if (useMapper) {
            return this.makeMappedCompactV(range);
        }
        return this.makeArrayCompactV(range);
    }

    private int[] makeArrayVi(int rangeV) {
        int[] res = new int[rangeV];
        for (int i = this.minIndexV; i <= this.maxIndexV; ++i) {
            byte b = this.mapperV[i - this.startV];
            if (b == 0) continue;
            res[i - this.minIndexV] = -1 - this.values[255 - b & 0xFF];
        }
        return res;
    }

    private IARTNode makeArrayCompactV(int rangeV) {
        int[] res = this.makeArrayVi(rangeV);
        return new ARTNode1Vi(this.minIndexV, this.countV, res);
    }

    private byte[] makeMapperV(int rangeV) {
        byte[] newMapper = this.mapperV;
        if ((rangeV + 7 & 0xF8) < this.mapperV.length) {
            newMapper = new byte[rangeV];
            System.arraycopy(this.mapperV, this.minIndexV - this.startV, newMapper, 0, rangeV);
        }
        return newMapper;
    }

    private int[] makeMappedArrayVi() {
        int[] newValues = this.values;
        if ((this.countV + 1 & 0xFE) < this.values.length) {
            newValues = new int[this.countV];
            System.arraycopy(this.values, 0, newValues, 0, this.countV);
        }
        return newValues;
    }

    private IARTNode makeMappedCompactV(int range) {
        byte[] newMapper = this.makeMapperV(range);
        int newStart = newMapper == this.mapperV ? this.startV : this.minIndexV;
        int[] newValues = this.makeMappedArrayVi();
        return new ARTNode1VibC(newStart, newMapper, newValues);
    }

    @Override
    public IARTNode compact() {
        if (this.countV == 0) {
            return this.compactN();
        }
        if (this.countN == 0) {
            return this.compactV();
        }
        return this.compactX();
    }
}

