/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.trie.nodes;

import java.util.NoSuchElementException;
import org.openl.domain.AIntIterator;
import org.openl.domain.IIntIterator;

public class ObjectArrayIterator
extends AIntIterator {
    int start;
    Object[] data;
    int position;

    private ObjectArrayIterator(int start, Object[] data) {
        this.start = start;
        this.data = data;
        this.nextPosition(0);
    }

    void nextPosition(int from) {
        while (from < this.data.length && this.data[from] == null) {
            ++from;
        }
        this.position = from;
    }

    @Override
    public int nextInt() {
        if (this.position >= this.data.length) {
            throw new NoSuchElementException();
        }
        int res = this.start + this.position;
        this.nextPosition(this.position + 1);
        return res;
    }

    @Override
    public boolean isResetable() {
        return true;
    }

    @Override
    public void reset() {
        this.nextPosition(0);
    }

    @Override
    public boolean hasNext() {
        return this.position < this.data.length;
    }

    public static IIntIterator iterator(int start, Object[] data) {
        return data == null ? AIntIterator.fromValue(new int[0]) : new ObjectArrayIterator(start, data);
    }
}

