/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.loader.condition;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.openl.rules.mapping.exception.RulesMappingException;
import org.openl.rules.mapping.loader.ProxyMethodHandler;
import org.openl.rules.mapping.loader.condition.DefaultConditionHandler;
import org.openl.rules.mapping.loader.condition.MappingParamsAwareConditionHandler;
import org.openl.rules.mapping.loader.condition.SimpleConditionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConditionInvocationHander
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConditionInvocationHander.class);
    private static final ProxyMethodHandler[] handlers = new ProxyMethodHandler[]{new MappingParamsAwareConditionHandler(), new SimpleConditionHandler(), new DefaultConditionHandler()};
    private String condition;
    private Class<?> instanceClass;
    private Object instance;
    private ProxyMethodHandler conditionHandler;
    private Method conditionMethod;

    public ConditionInvocationHander(String condition, Class<?> instanceClass, Object instance) {
        this.condition = condition;
        this.instanceClass = instanceClass;
        this.instance = instance;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        for (ProxyMethodHandler handler : handlers) {
            Method matchingMethod;
            if (!handler.canHandle(method) || handler == this.conditionHandler || (matchingMethod = handler.findMatchingMethod(this.instanceClass, this.condition, args)) == null) continue;
            this.conditionHandler = handler;
            this.conditionMethod = matchingMethod;
            break;
        }
        if (this.conditionMethod == null) {
            throw new RulesMappingException(String.format("Cannot find condition method with name '%s'", this.condition));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Getting ready to invoke condition method: %s", this.conditionMethod));
        }
        return this.conditionHandler.invoke(this.instance, this.conditionMethod, args);
    }
}

