/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.loader.discriminator;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.openl.rules.mapping.exception.RulesMappingException;
import org.openl.rules.mapping.loader.ProxyMethodHandler;
import org.openl.rules.mapping.loader.discriminator.DefaultCollectionItemDiscriminatorHandler;
import org.openl.rules.mapping.loader.discriminator.MappingParamsAwareCollectionItemDiscriminatorHandler;
import org.openl.rules.mapping.loader.discriminator.SimpleCollectionItemDiscriminatorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionItemDiscriminatorInvocationHander
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionItemDiscriminatorInvocationHander.class);
    private static final ProxyMethodHandler[] handlers = new ProxyMethodHandler[]{new MappingParamsAwareCollectionItemDiscriminatorHandler(), new SimpleCollectionItemDiscriminatorHandler(), new DefaultCollectionItemDiscriminatorHandler()};
    private String discriminator;
    private Class<?> instanceClass;
    private Object instance;
    private ProxyMethodHandler discriminatorHandler;
    private Method discriminatorMethod;

    public CollectionItemDiscriminatorInvocationHander(String discriminator, Class<?> instanceClass, Object instance) {
        this.discriminator = discriminator;
        this.instanceClass = instanceClass;
        this.instance = instance;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        for (ProxyMethodHandler handler : handlers) {
            Method matchingMethod;
            if (!handler.canHandle(method) || handler == this.discriminatorHandler || (matchingMethod = handler.findMatchingMethod(this.instanceClass, this.discriminator, args)) == null) continue;
            this.discriminatorHandler = handler;
            this.discriminatorMethod = matchingMethod;
            break;
        }
        if (this.discriminatorMethod == null) {
            throw new RulesMappingException(String.format("Cannot find discriminator method with name '%s'", this.discriminator));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Getting ready to invoke discriminator method: %s", this.discriminatorMethod));
        }
        return this.discriminatorHandler.invoke(this.instance, this.discriminatorMethod, args);
    }
}

