/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.loader.dozer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dozer.CustomConverter;
import org.dozer.DozerEventListener;
import org.dozer.FieldMappingCondition;
import org.dozer.loader.api.BeanMappingBuilder;
import org.dozer.loader.api.FieldDefinition;
import org.dozer.loader.api.FieldsMappingOption;
import org.dozer.loader.api.TypeMappingBuilder;
import org.openl.rules.mapping.definition.BeanMap;
import org.openl.rules.mapping.definition.CollectionItemDiscriminatorDescriptor;
import org.openl.rules.mapping.definition.ConditionDescriptor;
import org.openl.rules.mapping.definition.ConverterDescriptor;
import org.openl.rules.mapping.definition.FieldMap;
import org.openl.rules.mapping.loader.dozer.DozerMappingsContainer;
import org.openl.rules.mapping.loader.dozer.FieldDefinitionBuilder;
import org.openl.rules.mapping.loader.dozer.FieldMappingOptionsBuilder;
import org.openl.rules.mapping.loader.dozer.TypeDefinitionBuilder;
import org.openl.rules.mapping.loader.dozer.TypeMappingOptionsBuilder;

public class DozerMappingBuilder {
    private DozerMappingsContainer mappingsContainer = new DozerMappingsContainer();

    public DozerMappingBuilder mapping(BeanMap beanMapping) {
        this.addMapping(beanMapping);
        return this;
    }

    public DozerMappingBuilder customConvertersWithId(Map<String, CustomConverter> userConverters) {
        if (userConverters != null) {
            this.mappingsContainer.getConverters().putAll(userConverters);
        }
        return this;
    }

    public DozerMappingBuilder conditionsWithId(Map<String, FieldMappingCondition> conditionsWithId) {
        if (conditionsWithId != null) {
            this.mappingsContainer.getConditions().putAll(conditionsWithId);
        }
        return this;
    }

    public DozerMappingsContainer build() {
        return this.mappingsContainer;
    }

    private void addMapping(BeanMap beanMapping) {
        final TypeDefinitionBuilder srcTypeBuilder = new TypeDefinitionBuilder(beanMapping.getSrcClass());
        final TypeDefinitionBuilder destTypeBuilder = new TypeDefinitionBuilder(beanMapping.getDestClass());
        if (beanMapping.getConfiguration().getClassBBeanFactory() != null) {
            destTypeBuilder.beanFactory(beanMapping.getConfiguration().getClassBBeanFactory().getName());
        }
        final TypeMappingOptionsBuilder typeOptionsBuilder = new TypeMappingOptionsBuilder();
        typeOptionsBuilder.oneWay();
        typeOptionsBuilder.wildcard(beanMapping.getConfiguration().isWildcard());
        typeOptionsBuilder.trimStrings(beanMapping.getConfiguration().isTrimStrings());
        typeOptionsBuilder.mapEmptyStrings(beanMapping.getConfiguration().isMapEmptyStrings());
        typeOptionsBuilder.mapNulls(beanMapping.getConfiguration().isMapNulls());
        typeOptionsBuilder.dateFormat(beanMapping.getConfiguration().getDateFormat());
        typeOptionsBuilder.requiredFields(beanMapping.getConfiguration().isRequiredFields());
        final ArrayList<FieldsMapping> fieldsMappings = new ArrayList<FieldsMapping>(beanMapping.getFieldMappings().size());
        for (FieldMap fieldMapping : beanMapping.getFieldMappings()) {
            fieldsMappings.add(this.buildFieldMappping(fieldMapping));
        }
        for (FieldsMapping fieldsMapping : fieldsMappings) {
            if (fieldsMapping.getCondition() != null && !this.mappingsContainer.getConditions().containsKey(fieldsMapping.getCondition().getConditionId())) {
                this.mappingsContainer.getConditions().put(fieldsMapping.getCondition().getConditionId(), fieldsMapping.getCondition().getFieldMappingCondition());
            }
            if (fieldsMapping.getConverter() != null && !this.mappingsContainer.getConverters().containsKey(fieldsMapping.getConverter().getConverterId())) {
                this.mappingsContainer.getConverters().put(fieldsMapping.getConverter().getConverterId(), fieldsMapping.getConverter().getInstance());
            }
            if (fieldsMapping.getCollectionItemDiscriminator() == null || this.mappingsContainer.getCollectionItemDiscriminators().containsKey(fieldsMapping.getCollectionItemDiscriminator().getDiscriminatorId())) continue;
            this.mappingsContainer.getCollectionItemDiscriminators().put(fieldsMapping.getCollectionItemDiscriminator().getDiscriminatorId(), fieldsMapping.getCollectionItemDiscriminator().getDiscriminator());
        }
        BeanMappingBuilder beanMappingBuilder = new BeanMappingBuilder(){

            protected void configure() {
                TypeMappingBuilder mappingBuilder = this.mapping(srcTypeBuilder.build(), destTypeBuilder.build(), typeOptionsBuilder.build());
                for (FieldsMapping fieldsMapping : fieldsMappings) {
                    mappingBuilder.fields(fieldsMapping.getSrc(), fieldsMapping.getDest(), fieldsMapping.getOptions());
                }
            }
        };
        this.mappingsContainer.getMappingBuilders().add(beanMappingBuilder);
    }

    public DozerMappingBuilder eventListeners(List<DozerEventListener> eventListeners) {
        if (eventListeners != null) {
            this.mappingsContainer.getEventListeners().addAll(eventListeners);
        }
        return this;
    }

    private FieldsMapping buildFieldMappping(FieldMap fieldMap) {
        FieldsMapping fieldsMapping = new FieldsMapping();
        String[] src = fieldMap.getSrc();
        if (src != null && src.length > 1) {
            FieldDefinition[] definitions = new FieldDefinition[src.length];
            for (int i = 0; i < src.length; ++i) {
                FieldDefinitionBuilder fieldDefBuilder = new FieldDefinitionBuilder(src[i]);
                if (fieldMap.getSrcHint() != null && fieldMap.getSrcHint()[i] != null) {
                    Class<?>[] fieldHint = fieldMap.getSrcHint()[i];
                    fieldDefBuilder.deepHint(this.getHint(fieldHint));
                }
                if (fieldMap.getSrcType() != null && fieldMap.getSrcType().length != 0 && fieldMap.getSrcType()[i] != null) {
                    fieldDefBuilder.hint(this.getHint(fieldMap.getSrcType()));
                }
                if (fieldMap.getSrcDateFormat() != null && fieldMap.getSrcDateFormat().length != 0 && fieldMap.getSrcDateFormat()[i] != null) {
                    fieldDefBuilder.dateFormat(fieldMap.getSrcDateFormat()[i]);
                }
                definitions[i] = fieldDefBuilder.build();
            }
            fieldsMapping.setSrc(definitions);
        } else {
            String fieldName = "";
            if (src != null && src.length > 0 && StringUtils.isNotEmpty((String)src[0])) {
                fieldName = src[0];
            }
            FieldDefinitionBuilder fieldDefBuilder = new FieldDefinitionBuilder(fieldName);
            if (fieldMap.getSrcHint() != null && fieldMap.getSrcHint()[0] != null) {
                Class<?>[] fieldHint = fieldMap.getSrcHint()[0];
                fieldDefBuilder.deepHint(this.getHint(fieldHint));
            }
            if (fieldMap.getSrcType() != null && fieldMap.getSrcType()[0] != null) {
                fieldDefBuilder.hint(this.getHint(fieldMap.getSrcType()[0]));
            }
            if (fieldMap.getSrcDateFormat() != null && fieldMap.getSrcDateFormat()[0] != null) {
                fieldDefBuilder.dateFormat(fieldMap.getSrcDateFormat()[0]);
            }
            fieldsMapping.setSrc(new FieldDefinition[]{fieldDefBuilder.build()});
        }
        FieldDefinitionBuilder fieldDefBuilder = new FieldDefinitionBuilder(fieldMap.getDest());
        fieldDefBuilder.required(fieldMap.isRequired());
        fieldDefBuilder.defaultValue(fieldMap.getDefaultValue());
        fieldDefBuilder.createMethod(fieldMap.getCreateMethod());
        if (fieldMap.getDestDateFormat() != null) {
            fieldDefBuilder.dateFormat(fieldMap.getDestDateFormat());
        }
        if (fieldMap.getDestHint() != null) {
            fieldDefBuilder.deepHint(this.getHint(fieldMap.getDestHint()));
        }
        if (fieldMap.getDestType() != null) {
            fieldDefBuilder.hint(this.getHint(fieldMap.getDestType()));
        }
        FieldMappingOptionsBuilder optionsBuilder = new FieldMappingOptionsBuilder();
        optionsBuilder.mapNulls(fieldMap.isMapNulls());
        optionsBuilder.mapEmptyStrings(fieldMap.isMapEmptyStrings());
        optionsBuilder.trimStrings(fieldMap.isTrimStrings());
        optionsBuilder.mapId(fieldMap.getMapId());
        if (fieldMap.getConverter() != null) {
            optionsBuilder.customConverterId(fieldMap.getConverter().getConverterId());
            fieldsMapping.setConverter(fieldMap.getConverter());
        }
        if (fieldMap.getCondition() != null) {
            optionsBuilder.conditionId(fieldMap.getCondition().getConditionId());
            fieldsMapping.setCondition(fieldMap.getCondition());
        }
        if (fieldMap.getCollectionItemDiscriminator() != null) {
            optionsBuilder.collectionItemDiscriminatorId(fieldMap.getCollectionItemDiscriminator().getDiscriminatorId());
            fieldsMapping.setCollectionItemDiscriminator(fieldMap.getCollectionItemDiscriminator());
        }
        fieldsMapping.setDest(fieldDefBuilder.build());
        fieldsMapping.setOptions(optionsBuilder.build());
        return fieldsMapping;
    }

    private String getHint(Class<?> ... types) {
        Object[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            names[i] = types[i] == null ? "" : types[i].getName();
        }
        return StringUtils.join((Object[])names, (String)",");
    }

    private static class FieldsMapping {
        private FieldDefinition[] src;
        private FieldDefinition dest;
        private FieldsMappingOption[] options;
        private ConverterDescriptor converter;
        private ConditionDescriptor condition;
        private CollectionItemDiscriminatorDescriptor collectionItemDiscriminator;

        private FieldsMapping() {
        }

        public FieldDefinition[] getSrc() {
            return this.src;
        }

        public void setSrc(FieldDefinition[] src) {
            this.src = src;
        }

        public FieldDefinition getDest() {
            return this.dest;
        }

        public void setDest(FieldDefinition dest) {
            this.dest = dest;
        }

        public FieldsMappingOption[] getOptions() {
            return this.options;
        }

        public void setOptions(FieldsMappingOption[] options) {
            this.options = options;
        }

        public ConverterDescriptor getConverter() {
            return this.converter;
        }

        public void setConverter(ConverterDescriptor converter) {
            this.converter = converter;
        }

        public ConditionDescriptor getCondition() {
            return this.condition;
        }

        public void setCondition(ConditionDescriptor condition) {
            this.condition = condition;
        }

        public CollectionItemDiscriminatorDescriptor getCollectionItemDiscriminator() {
            return this.collectionItemDiscriminator;
        }

        public void setCollectionItemDiscriminator(CollectionItemDiscriminatorDescriptor collectionItemDiscriminator) {
            this.collectionItemDiscriminator = collectionItemDiscriminator;
        }
    }
}

