/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.validation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.dozer.util.MappingUtils;
import org.openl.rules.mapping.Mapping;
import org.openl.rules.mapping.MappingParameters;
import org.openl.rules.mapping.OpenLReflectionUtils;
import org.openl.rules.mapping.TypeResolver;
import org.openl.rules.mapping.loader.MappingDefinitionUtils;
import org.openl.rules.mapping.validation.BeanValidationResult;
import org.openl.rules.mapping.validation.ConstraintViolation;
import org.openl.rules.mapping.validation.FieldPathHierarchyElement;
import org.openl.rules.mapping.validation.OpenLDataBeanValidator;
import org.openl.rules.mapping.validation.PropertyConstraintViolation;
import org.openl.rules.mapping.validation.utils.ClassMetaInfo;
import org.openl.rules.mapping.validation.utils.MethodMetaInfo;
import org.openl.rules.mapping.validation.utils.ValidationUtils;
import org.openl.types.IOpenClass;
import org.openl.validation.ValidationStatus;

public class MappingBeanValidator
extends OpenLDataBeanValidator<Mapping> {
    @Override
    public BeanValidationResult validateBean(Mapping beanToValidate, IOpenClass openClass) {
        HashSet<ConstraintViolation> violations = new HashSet<ConstraintViolation>();
        Mapping bean = MappingDefinitionUtils.normalizeMapping(beanToValidate);
        Set<ConstraintViolation> fieldPathViolations = this.validateFieldPaths(bean);
        violations.addAll(fieldPathViolations);
        if (fieldPathViolations.isEmpty()) {
            violations.addAll(this.validateConvertMethods(bean, openClass));
            violations.addAll(this.validateConditionMethods(bean, openClass));
            violations.addAll(this.validateDiscriminatorMethods(bean, openClass));
        }
        if (violations.isEmpty()) {
            return new BeanValidationResult(ValidationStatus.SUCCESS, bean.getClass());
        }
        BeanValidationResult result = new BeanValidationResult(ValidationStatus.FAIL, bean.getClass());
        result.addAllConstraintViolation(violations);
        return result;
    }

    private Set<ConstraintViolation> validateConvertMethods(Mapping bean, IOpenClass openClass) {
        HashSet<ConstraintViolation> violations = new HashSet<ConstraintViolation>();
        Class<?> fieldAType = this.getFieldAType(bean);
        Class<?> fieldBType = this.getFieldBType(bean);
        violations.addAll(this.validateConvertMethod("convertMethodAB", bean.getConvertMethodAB(), openClass, fieldAType, fieldBType));
        violations.addAll(this.validateConvertMethod("convertMethodBA", bean.getConvertMethodBA(), openClass, fieldBType, fieldAType));
        return violations;
    }

    private Set<ConstraintViolation> validateConditionMethods(Mapping bean, IOpenClass openClass) {
        HashSet<ConstraintViolation> violations = new HashSet<ConstraintViolation>();
        Class<?> fieldAType = this.getFieldAType(bean);
        Class<?> fieldBType = this.getFieldBType(bean);
        violations.addAll(this.validateConditionMethod("conditionAB", bean.getConditionAB(), openClass, fieldAType, fieldBType));
        violations.addAll(this.validateConditionMethod("conditionBA", bean.getConditionBA(), openClass, fieldBType, fieldAType));
        return violations;
    }

    private Set<ConstraintViolation> validateDiscriminatorMethods(Mapping bean, IOpenClass openClass) {
        HashSet<ConstraintViolation> violations = new HashSet<ConstraintViolation>();
        Class<?> fieldAType = this.getFieldAType(bean);
        Class<?> fieldBType = this.getFieldBType(bean);
        Class<?> fieldAEntryTypeHint = null;
        if (bean.getFieldAType() != null && bean.getFieldAType().length == 1) {
            fieldAEntryTypeHint = bean.getFieldAType()[0];
        }
        Class<?> fieldBEntryTypeHint = bean.getFieldBType();
        violations.addAll(this.validateDiscriminatorMethod("fieldBDiscriminator", bean.getFieldBDiscriminator(), openClass, fieldAType, fieldBType, fieldAEntryTypeHint, fieldBEntryTypeHint));
        violations.addAll(this.validateDiscriminatorMethod("fieldADiscriminator", bean.getFieldADiscriminator(), openClass, fieldBType, fieldAType, fieldBEntryTypeHint, fieldAEntryTypeHint));
        return violations;
    }

    private Class<?> getFieldAType(Mapping bean) {
        String[] fieldA = bean.getFieldA();
        Class fieldAType = null;
        if (fieldA == null) {
            fieldAType = Object.class;
        } else if (fieldA.length > 1) {
            fieldAType = Object[].class;
        } else {
            Class<?>[] fieldTypeHint = null;
            if (bean.getFieldAHint() != null) {
                fieldTypeHint = bean.getFieldAHint()[0];
            }
            FieldPathHierarchyElement[] hierarchy = ValidationUtils.getFieldHierarchy(bean.getClassA(), fieldA[0], fieldTypeHint);
            FieldPathHierarchyElement lastElement = hierarchy[hierarchy.length - 1];
            fieldAType = lastElement.getType();
            if (StringUtils.isNotBlank((String)lastElement.getIndex()) && MappingUtils.isSupportedCollection(lastElement.getType())) {
                Class<?> entryTypeHint = bean.getFieldAType() != null ? bean.getFieldAType()[0] : null;
                fieldAType = ValidationUtils.getSupportedCollectionEntryType(lastElement.getType(), entryTypeHint);
            }
        }
        return fieldAType;
    }

    private Class<?> getFieldBType(Mapping bean) {
        String fieldB = bean.getFieldB();
        Class<?> fieldBType = null;
        Class<?>[] fieldBTypeHint = bean.getFieldBHint();
        FieldPathHierarchyElement[] hierarchy = ValidationUtils.getFieldHierarchy(bean.getClassB(), fieldB, fieldBTypeHint);
        FieldPathHierarchyElement lastElement = hierarchy[hierarchy.length - 1];
        fieldBType = lastElement.getType();
        if (StringUtils.isNotBlank((String)lastElement.getIndex()) && MappingUtils.isSupportedCollection(lastElement.getType())) {
            Class<?> entryTypeHint = bean.getFieldBType();
            fieldBType = ValidationUtils.getSupportedCollectionEntryType(lastElement.getType(), entryTypeHint);
        }
        return fieldBType;
    }

    private Set<ConstraintViolation> validateConvertMethod(String propertyName, String convertMethod, IOpenClass openClass, Class<?> fieldA, Class<?> fieldB) {
        ClassMetaInfo returnType;
        HashSet<ConstraintViolation> violations = new HashSet<ConstraintViolation>();
        if (StringUtils.isBlank((String)convertMethod)) {
            return violations;
        }
        String convertMethodClassName = MappingDefinitionUtils.getTypeName(convertMethod);
        String convertMethodName = MappingDefinitionUtils.getMethodName(convertMethod);
        Class<?> convertMethodClass = null;
        TypeResolver typeResolver = OpenLReflectionUtils.getTypeResolver(openClass);
        if (StringUtils.isNotBlank((String)convertMethodClassName)) {
            convertMethodClass = typeResolver.findClass(convertMethodClassName);
        }
        String className = null;
        MethodMetaInfo simpleMethod = null;
        MethodMetaInfo extendedMethod = null;
        if (convertMethodClass != null) {
            simpleMethod = ValidationUtils.findMethod(convertMethodClass, convertMethodName, new Class[]{fieldA, fieldB});
            extendedMethod = ValidationUtils.findMethod(convertMethodClass, convertMethodName, new Class[]{MappingParameters.class, fieldA, fieldB});
            className = convertMethodClass.getName();
        } else {
            simpleMethod = ValidationUtils.findMethod(openClass, convertMethodName, new Class[]{fieldA, fieldB});
            extendedMethod = ValidationUtils.findMethod(openClass, convertMethodName, new Class[]{MappingParameters.class, fieldA, fieldB});
            className = openClass.getName();
        }
        if (simpleMethod == null && extendedMethod == null) {
            violations.add(this.createPropertyViolation(propertyName, convertMethod, String.format("Convert method '%1$s(%2$s, %3$s)' or '%1$s(%4$s, %2$s, %3$s)' cannot be found in class '%5$s'", convertMethod, fieldA.getName(), fieldB.getName(), MappingParameters.class.getName(), className)));
        }
        if (!(simpleMethod == null || (returnType = simpleMethod.getReturnType()) != null && OpenLReflectionUtils.isAssignableFrom(fieldB, returnType.getInstanceClass()))) {
            violations.add(this.createPropertyViolation(propertyName, convertMethod, String.format("Destination field of type '%s' cannot be assigned from value of '%s' type", fieldB.getName(), returnType.getName())));
        }
        if (!(extendedMethod == null || (returnType = extendedMethod.getReturnType()) != null && OpenLReflectionUtils.isAssignableFrom(fieldB, returnType.getInstanceClass()))) {
            violations.add(this.createPropertyViolation(propertyName, convertMethod, String.format("Destination field of type '%s' cannot be assigned from value of '%s' type", fieldB.getName(), returnType.getName())));
        }
        return violations;
    }

    private Set<ConstraintViolation> validateConditionMethod(String propertyName, String conditionMethod, IOpenClass openClass, Class<?> fieldA, Class<?> fieldB) {
        ClassMetaInfo returnType;
        HashSet<ConstraintViolation> violations = new HashSet<ConstraintViolation>();
        if (StringUtils.isBlank((String)conditionMethod)) {
            return violations;
        }
        String conditionMethodClassName = MappingDefinitionUtils.getTypeName(conditionMethod);
        String conditionMethodName = MappingDefinitionUtils.getMethodName(conditionMethod);
        Class<?> conditionMethodClass = null;
        TypeResolver typeResolver = OpenLReflectionUtils.getTypeResolver(openClass);
        if (StringUtils.isNotBlank((String)conditionMethodClassName)) {
            conditionMethodClass = typeResolver.findClass(conditionMethodClassName);
        }
        String className = null;
        MethodMetaInfo simpleMethod = null;
        MethodMetaInfo extendedMethod = null;
        if (conditionMethodClass != null) {
            simpleMethod = ValidationUtils.findMethod(conditionMethodClass, conditionMethodName, new Class[]{fieldA, fieldB});
            extendedMethod = ValidationUtils.findMethod(conditionMethodClass, conditionMethodName, new Class[]{MappingParameters.class, fieldA, fieldB});
            className = conditionMethodClass.getName();
        } else {
            simpleMethod = ValidationUtils.findMethod(openClass, conditionMethodName, new Class[]{fieldA, fieldB});
            extendedMethod = ValidationUtils.findMethod(openClass, conditionMethodName, new Class[]{MappingParameters.class, fieldA, fieldB});
            className = openClass.getName();
        }
        if (simpleMethod == null && extendedMethod == null) {
            violations.add(this.createPropertyViolation(propertyName, conditionMethod, String.format("Convert method '%1$s(%2$s, %3$s)' or '%1$s(%4$s, %2$s, %3$s)' cannot be found in class '%5$s'", conditionMethod, fieldA.getName(), fieldB.getName(), MappingParameters.class.getName(), className)));
        }
        if (simpleMethod != null && Boolean.TYPE != (returnType = simpleMethod.getReturnType()).getInstanceClass() && !Boolean.class.equals(returnType.getInstanceClass())) {
            violations.add(this.createPropertyViolation(propertyName, conditionMethod, "Condition method have to return value of boolean type"));
        }
        if (extendedMethod != null && Boolean.TYPE != (returnType = extendedMethod.getReturnType()).getInstanceClass() && !Boolean.class.equals(returnType.getInstanceClass())) {
            violations.add(this.createPropertyViolation(propertyName, conditionMethod, "Condition method have to return value of boolean type"));
        }
        return violations;
    }

    private Set<ConstraintViolation> validateDiscriminatorMethod(String propertyName, String methodName, IOpenClass openClass, Class<?> fieldA, Class<?> fieldB, Class<?> fieldAEntryTypeHint, Class<?> fieldBEntryTypeHint) {
        HashSet<ConstraintViolation> violations = new HashSet<ConstraintViolation>();
        if (StringUtils.isBlank((String)methodName)) {
            return violations;
        }
        String discriminatorMethodClassName = MappingDefinitionUtils.getTypeName(methodName);
        String discriminatorMethodName = MappingDefinitionUtils.getMethodName(methodName);
        Class<?> discriminatorMethodClass = null;
        TypeResolver typeResolver = OpenLReflectionUtils.getTypeResolver(openClass);
        if (StringUtils.isNotBlank((String)discriminatorMethodClassName)) {
            discriminatorMethodClass = typeResolver.findClass(discriminatorMethodClassName);
        }
        Class<?> fieldAType = ValidationUtils.getCollectionFieldType(fieldA, fieldAEntryTypeHint);
        Class<?> fieldBType = ValidationUtils.getCollectionFieldType(fieldB, fieldBEntryTypeHint);
        Class<?> fieldAEntryType = ValidationUtils.getSupportedCollectionEntryType(fieldAType, fieldAEntryTypeHint);
        String className = null;
        MethodMetaInfo simpleMethod = null;
        MethodMetaInfo extendedMethod = null;
        if (discriminatorMethodClass != null) {
            simpleMethod = ValidationUtils.findMethod(discriminatorMethodClass, discriminatorMethodName, new Class[]{fieldAEntryType, fieldBType});
            extendedMethod = ValidationUtils.findMethod(discriminatorMethodClass, discriminatorMethodName, new Class[]{MappingParameters.class, fieldAType, fieldBType});
            className = discriminatorMethodClass.getName();
        } else {
            simpleMethod = ValidationUtils.findMethod(openClass, discriminatorMethodName, new Class[]{fieldAType, fieldBType});
            extendedMethod = ValidationUtils.findMethod(openClass, discriminatorMethodName, new Class[]{MappingParameters.class, fieldAEntryType, fieldBType});
            className = openClass.getName();
        }
        if (!ValidationUtils.isSupportedCollection(fieldB)) {
            violations.add(this.createPropertyViolation(propertyName, fieldB.getName(), String.format("Target field '%s' should be an array or a collection", fieldB.getName())));
        } else if (simpleMethod == null && extendedMethod == null) {
            violations.add(this.createPropertyViolation(propertyName, methodName, String.format("Discriminator method '%1$s(%2$s, %3$s)' or '%1$s(%4$s, %2$s, %3$s)' cannot be found in class '%5$s'", methodName, fieldAEntryType.getName(), fieldBType.getName(), MappingParameters.class.getName(), className)));
        } else {
            Class<?> entryType = ValidationUtils.getSupportedCollectionEntryType(fieldB, fieldBEntryTypeHint);
            ClassMetaInfo returnType = null;
            if (simpleMethod != null) {
                returnType = simpleMethod.getReturnType();
            }
            if (extendedMethod != null) {
                returnType = extendedMethod.getReturnType();
            }
            if (returnType == null || !OpenLReflectionUtils.isAssignableFrom(entryType, returnType.getInstanceClass())) {
                String returnTypeName = returnType == null ? null : returnType.getName();
                violations.add(this.createPropertyViolation(propertyName, methodName, String.format("Destination collection item of type '%s' cannot be assigned from value of '%s' type", entryType.getName(), returnTypeName)));
            }
        }
        return violations;
    }

    private Set<ConstraintViolation> validateFieldPaths(Mapping bean) {
        List<FieldPathHierarchyElement> hierarchyElementList;
        Collection invalidElements;
        String message;
        FieldPathHierarchyElement[] hierarchy;
        HashSet<ConstraintViolation> violations = new HashSet<ConstraintViolation>();
        Class<?> classAType = bean.getClassA();
        String[] fieldA = bean.getFieldA();
        if (fieldA != null) {
            for (int i = 0; i < fieldA.length; ++i) {
                String field = fieldA[i];
                Class<?>[] fieldTypeHint = null;
                if (bean.getFieldAHint() != null) {
                    fieldTypeHint = bean.getFieldAHint()[i];
                }
                hierarchy = null;
                try {
                    hierarchy = ValidationUtils.getFieldHierarchy(classAType, field, fieldTypeHint);
                }
                catch (Exception ex) {
                    message = ex.getMessage();
                    if (StringUtils.isBlank((String)message)) {
                        message = String.format("Exception occurred determining field hierarchy for Class --> %s, Field --> %s", classAType == null ? null : classAType.getName(), field);
                    }
                    violations.add(this.createPropertyViolation("fieldA", field, message));
                }
                if (hierarchy == null || (invalidElements = CollectionUtils.select(hierarchyElementList = Arrays.asList(hierarchy), (Predicate)new Predicate(){

                    public boolean evaluate(Object arg) {
                        FieldPathHierarchyElement e = (FieldPathHierarchyElement)arg;
                        String index = e.getIndex();
                        return StringUtils.isNotBlank((String)index) && ValidationUtils.isSimpleCollectionIndex(index) && ValidationUtils.getCollectionIndex(index) == -1;
                    }
                })).isEmpty()) continue;
                for (FieldPathHierarchyElement e : invalidElements) {
                    violations.add(this.createPropertyViolation("fieldA", field, String.format("Index value '%s' cannot be used for source field", e.getIndex())));
                }
            }
        }
        Class<?> classBType = bean.getClassB();
        String fieldB = bean.getFieldB();
        Class<?>[] fieldBTypeHint = bean.getFieldBHint();
        hierarchy = null;
        try {
            hierarchy = ValidationUtils.getFieldHierarchy(classBType, fieldB, fieldBTypeHint);
        }
        catch (Exception ex) {
            message = ex.getMessage();
            if (StringUtils.isBlank((String)message)) {
                message = String.format("Exception occurred determining field hierarchy for Class --> %s, Field --> %s", classBType == null ? null : classBType.getName(), fieldB);
            }
            violations.add(this.createPropertyViolation("fieldB", fieldB, message));
        }
        if (hierarchy != null && !(invalidElements = CollectionUtils.select(hierarchyElementList = Arrays.asList(hierarchy), (Predicate)new Predicate(){

            public boolean evaluate(Object arg) {
                FieldPathHierarchyElement e = (FieldPathHierarchyElement)arg;
                String index = e.getIndex();
                return StringUtils.isNotBlank((String)index) && !ValidationUtils.isSimpleCollectionIndex(index);
            }
        })).isEmpty()) {
            for (FieldPathHierarchyElement e : invalidElements) {
                violations.add(this.createPropertyViolation("fieldB", fieldB, String.format("Index value '%s' cannot be used for destination field", e.getIndex())));
            }
        }
        return violations;
    }

    private PropertyConstraintViolation createPropertyViolation(String propertyName, Object invalidValue, String violationMessage) {
        PropertyConstraintViolation violation = new PropertyConstraintViolation();
        violation.setInvalidValue(invalidValue);
        violation.setMessage(violationMessage);
        violation.setPropertyName(propertyName);
        return violation;
    }
}

