/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.mapping.validation;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.OpenL;
import org.openl.exception.OpenLException;
import org.openl.message.OpenLErrorMessage;
import org.openl.rules.data.ColumnDescriptor;
import org.openl.rules.data.DataOpenField;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.mapping.validation.BeanValidationResult;
import org.openl.rules.mapping.validation.ConstraintViolation;
import org.openl.rules.mapping.validation.PropertyConstraintViolation;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.openl.GridCellSourceCodeModule;
import org.openl.rules.validation.ValidationUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.validation.IOpenLValidator;
import org.openl.validation.ValidationResult;
import org.openl.validation.ValidationStatus;

public abstract class OpenLDataBeanValidator<T>
implements IOpenLValidator {
    private Class<?> genericType;

    public abstract BeanValidationResult validateBean(T var1, IOpenClass var2);

    public ValidationResult validate(OpenL openl, IOpenClass openClass) {
        if (openClass instanceof XlsModuleOpenClass) {
            XlsMetaInfo xlsMetaInfo = ((XlsModuleOpenClass)openClass).getXlsMetaInfo();
            TableSyntaxNode[] tableSyntaxNodes = xlsMetaInfo.getXlsModuleNode().getXlsTableSyntaxNodes();
            TableSyntaxNode[] fields = this.findFieldMembers(tableSyntaxNodes, this.getGenericType());
            ArrayList<OpenLErrorMessage> validationMessages = new ArrayList<OpenLErrorMessage>();
            for (TableSyntaxNode node : fields) {
                Object[] data = (Object[])((DataOpenField)node.getMember()).getData();
                for (int i = 0; i < data.length; ++i) {
                    Object bean = data[i];
                    BeanValidationResult result = this.validateBean(bean, openClass);
                    if (ValidationStatus.SUCCESS.equals((Object)result.getStatus())) continue;
                    List<SyntaxNodeException> errors = this.prepareErrorsList(result, i, node);
                    for (SyntaxNodeException error : errors) {
                        node.addError(error);
                        validationMessages.add(new OpenLErrorMessage((OpenLException)error));
                    }
                }
            }
            if (validationMessages.isEmpty()) {
                return new ValidationResult(ValidationStatus.SUCCESS, validationMessages);
            }
            return new ValidationResult(ValidationStatus.FAIL, validationMessages);
        }
        return ValidationUtils.validationSuccess();
    }

    private List<SyntaxNodeException> prepareErrorsList(BeanValidationResult result, int beanIndex, TableSyntaxNode syntaxNode) {
        Map<String, Integer> descriptorsMap = this.createDescriptorsMap(((DataOpenField)syntaxNode.getMember()).getTable().getDataModel().getDescriptor());
        ArrayList<SyntaxNodeException> errors = new ArrayList<SyntaxNodeException>();
        for (ConstraintViolation violation : result.getConstraintViolations()) {
            if (!(violation instanceof PropertyConstraintViolation)) continue;
            PropertyConstraintViolation propConstraintViolation = (PropertyConstraintViolation)violation;
            String invalidPropName = propConstraintViolation.getPropertyName();
            ILogicalTable cell = (ILogicalTable)((ILogicalTable)syntaxNode.getTableBody().getRows(2)).getSubtable(descriptorsMap.get(invalidPropName).intValue(), beanIndex, 1, 1);
            SyntaxNodeException ex = SyntaxNodeExceptionUtils.createError((String)violation.getMessage(), (IOpenSourceCodeModule)new GridCellSourceCodeModule(cell.getSource()));
            errors.add(ex);
        }
        return errors;
    }

    private Map<String, Integer> createDescriptorsMap(ColumnDescriptor[] descriptors) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < descriptors.length; ++i) {
            map.put(descriptors[i].getName(), i);
        }
        return map;
    }

    private TableSyntaxNode[] findFieldMembers(TableSyntaxNode[] tableSyntaxNodes, Class<?> fieldComponentType) {
        ArrayList<TableSyntaxNode> fields = new ArrayList<TableSyntaxNode>();
        for (TableSyntaxNode node : tableSyntaxNodes) {
            if (!(node.getMember() instanceof DataOpenField) || node.getMember().getType().getInstanceClass().getComponentType() != fieldComponentType) continue;
            fields.add(node);
        }
        return fields.toArray(new TableSyntaxNode[fields.size()]);
    }

    private Class<?> getGenericType() {
        if (this.genericType == null) {
            ParameterizedType superclass = (ParameterizedType)this.getClass().getGenericSuperclass();
            this.genericType = (Class)superclass.getActualTypeArguments()[0];
        }
        return this.genericType;
    }
}

