/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.ccc;

import java.util.Vector;
import org.openl.ie.ccc.CccConstraint;
import org.openl.ie.ccc.CccCore;
import org.openl.ie.ccc.CccExecutable;
import org.openl.ie.ccc.CccFloat;
import org.openl.ie.ccc.CccGoal;
import org.openl.ie.ccc.CccGoalSolution;
import org.openl.ie.ccc.CccGroup;
import org.openl.ie.ccc.CccInteger;
import org.openl.ie.ccc.CccJob;
import org.openl.ie.ccc.CccObject;
import org.openl.ie.ccc.CccResource;
import org.openl.ie.ccc.CccVariable;

public class CccView {
    CccCore _core;
    public String[] _obj_names = new String[0];

    public CccView(CccCore c) {
        this._core = c;
        this._obj_names = this.getGroups();
    }

    public boolean activateAllConstraints() {
        return this.core().activateAllConstraints();
    }

    public CccCore core() {
        return this._core;
    }

    public void deactivateAllConstraints() {
        this.core().deactivateAllConstraints();
    }

    public boolean exist(String obj) {
        return this.core().getObject(obj, 0) != null;
    }

    public int getColor(String obj, int i) {
        CccObject o = this.core().getObject(obj, i);
        if (o == null) {
            this.core().traceln("TRYING TO GET COLOR OF EMTPY: " + obj + "." + i);
        }
        return o == null ? -1 : o.status();
    }

    public String[] getDataGroups() {
        Vector<String> s = new Vector<String>();
        Vector gr = this.core().getGroups();
        for (int i = 0; i < gr.size(); ++i) {
            CccObject o;
            CccGroup g = (CccGroup)gr.get(i);
            if ("objective".equals(g.getName()) || g.size() <= 0 || !((o = g.getObject(0)) instanceof CccVariable)) continue;
            s.add(g.getName());
        }
        return s.toArray(new String[s.size()]);
    }

    public String[] getGroups() {
        Vector<String> s = new Vector<String>();
        Vector gr = this.core().getGroups();
        for (int i = 0; i < gr.size(); ++i) {
            CccGroup g = (CccGroup)gr.get(i);
            s.add(g.getName());
        }
        return s.toArray(new String[s.size()]);
    }

    public String getHtml(String obj, int i) {
        CccObject o = this.core().getObject(obj, i);
        if (o == null) {
            this.core().traceln("TRYING TO GET NAME OF EMTPY: " + obj + "." + i);
            return "";
        }
        return o.getHtml();
    }

    public String getHtmlForId(String id) {
        CccObject o = this.core().getObject(id);
        if (o == null) {
            this.core().traceln("TRYING TO GET NAME OF EMTPY: " + id);
            return "";
        }
        return o.getHtml();
    }

    public String getInfo(String obj, int i, String infotype) {
        CccObject o = this.core().getObject(obj, i);
        if (o == null) {
            this.core().traceln("TRYING TO GET INFO OF EMTPY: " + obj + "." + i);
            return "";
        }
        return o.getInfo(infotype);
    }

    public boolean getLastFailed() {
        return this.core().getLastFailed();
    }

    public int getMax(String obj, int i) {
        CccObject o = this.core().getObject(obj, i);
        if (o == null) {
            this.core().traceln("TRYING TO GET MAX OF EMTPY: " + obj + "." + i);
            return 0;
        }
        if (o instanceof CccInteger) {
            return ((CccInteger)o).max();
        }
        if (o instanceof CccFloat) {
            return (int)((CccFloat)o).max();
        }
        if (o instanceof CccJob) {
            return ((CccJob)o).endMax();
        }
        if (o instanceof CccResource) {
            return ((CccResource)o).constrainerResource().timeMax();
        }
        return 0;
    }

    public int getMaxSolutionNumber() {
        return this.core().getMaxSolutionNum();
    }

    public int getMin(String obj, int i) {
        CccObject o = this.core().getObject(obj, i);
        if (o == null) {
            this.core().traceln("TRYING TO GET MIN OF EMTPY: " + obj + "." + i);
            return 0;
        }
        if (o instanceof CccInteger) {
            return ((CccInteger)o).min();
        }
        if (o instanceof CccFloat) {
            return (int)((CccFloat)o).min();
        }
        if (o instanceof CccJob) {
            return ((CccJob)o).startMin();
        }
        if (o instanceof CccResource) {
            return ((CccResource)o).constrainerResource().timeMin();
        }
        return 0;
    }

    public String getName(String obj, int i) {
        CccObject o = this.core().getObject(obj, i);
        if (o == null) {
            this.core().traceln("TRYING TO GET NAME OF EMTPY: " + obj + "." + i);
            return "";
        }
        return o.name();
    }

    public String getNameForId(String id) {
        CccObject o = this.core().getObject(id);
        if (o == null) {
            this.core().traceln("TRYING TO GET NAME OF EMTPY: " + id);
            return "";
        }
        return o.name();
    }

    public int getSolutionNumber() {
        return this.core().getSolutionNumber();
    }

    public String getStatus() {
        return this.core().getStatus();
    }

    public int getTotal(String obj) {
        int r = -1;
        if ("all".equals(obj)) {
            r = 2;
        }
        if (obj.equalsIgnoreCase("goal")) {
            r = this.core().goals().size();
        }
        if (obj.equalsIgnoreCase("constraint")) {
            r = this.core().constraints().size();
        }
        if (obj.equalsIgnoreCase("job")) {
            r = this.core().jobs().size();
        }
        if (obj.equalsIgnoreCase("resource")) {
            r = this.core().resources().size();
        }
        if (obj.equalsIgnoreCase("integer")) {
            r = this.core().integers().size();
        }
        if (obj.equalsIgnoreCase("float")) {
            r = this.core().floats().size();
        }
        if (obj.equalsIgnoreCase("objective")) {
            int n = r = this.core().objective() == null ? 0 : 1;
        }
        if (r == -1 && this.core().existsGroup(obj)) {
            CccGroup g = this.core().getGroup(obj);
            r = g.size();
        }
        return r;
    }

    public String getValue(String obj, int i) {
        CccObject o = this.core().getObject(obj, i);
        if (o == null) {
            this.core().traceln("TRYING TO GET VALUE OF EMTPY: " + obj + "." + i);
            return "";
        }
        if (o instanceof CccVariable) {
            return ((CccVariable)o).value();
        }
        return "";
    }

    public boolean isSolution(String obj, int i) {
        CccObject o = this.core().getObject(obj, i);
        return o instanceof CccGoalSolution;
    }

    public boolean process(String obj, int i) {
        if (obj.equalsIgnoreCase("all")) {
            if (i == 1) {
                return this.activateAllConstraints();
            }
            if (i == 0) {
                this.deactivateAllConstraints();
            }
            return true;
        }
        if (obj.equalsIgnoreCase("goal")) {
            CccGoal g = this.core().getGoalByNum(i);
            if (this.core().isActivated(g.getId())) {
                this.core().deactivateGoal();
                this.setStatus("Deactivated goal: " + g.name());
            } else {
                this.core().activateGoal(g.getId());
                this.setStatus("Activated goal: " + g.name() + ", time: " + this.core().getExecutionTime() + "ms");
            }
            return true;
        }
        if (obj.equalsIgnoreCase("constraint")) {
            CccConstraint ex = this.core().getConstraintByNum(i);
            if (this.core().isActivated(ex.getId())) {
                ((CccExecutable)ex).deactivate();
                this.setStatus("Deactivated constraint: " + ex.name());
            } else {
                ex.activate();
            }
        }
        return true;
    }

    public boolean setSolutionNumber(int i) {
        boolean ok = this.core().isOk();
        boolean res = this.core().activateSolution(i);
        if (!res) {
            this.core().traceln("FAILED solution " + i + ", trying autosolution: " + this.core().getSolutionNumber());
            this.core().setOk(ok);
            res = this.core().activateSolution(this.core().getSolutionNumber());
        }
        return res;
    }

    public void setStatus(String s) {
        this.core().setStatus(s);
    }
}

