/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import org.openl.ie.constrainer.ChoicePointLabel;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.ExpressionFactory;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.FloatExpArray;
import org.openl.ie.constrainer.FloatVar;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalAllSolutions;
import org.openl.ie.constrainer.GoalAnd;
import org.openl.ie.constrainer.GoalCheckSolutionNumber;
import org.openl.ie.constrainer.IntArrayCards;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntBoolVar;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.IntSetVar;
import org.openl.ie.constrainer.IntVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.TimeLimitException;
import org.openl.ie.constrainer.Undo;
import org.openl.ie.constrainer.Undoable;
import org.openl.ie.constrainer.UndoableAction;
import org.openl.ie.constrainer.UndoableFloat;
import org.openl.ie.constrainer.UndoableInt;
import org.openl.ie.constrainer.impl.ConstraintAllDiff;
import org.openl.ie.constrainer.impl.ExpressionFactoryImpl;
import org.openl.ie.constrainer.impl.FloatVarImpl;
import org.openl.ie.constrainer.impl.FloatVarImplTrace;
import org.openl.ie.constrainer.impl.GoalStack;
import org.openl.ie.constrainer.impl.IntBoolVarImpl;
import org.openl.ie.constrainer.impl.IntExpCardIntExp;
import org.openl.ie.constrainer.impl.IntSetVarImpl;
import org.openl.ie.constrainer.impl.IntVarImpl;
import org.openl.ie.constrainer.impl.IntVarImplTrace;
import org.openl.ie.constrainer.impl.UndoFastVectorAdd;
import org.openl.ie.constrainer.impl.UndoStack;
import org.openl.ie.constrainer.impl.UndoableFloatImpl;
import org.openl.ie.constrainer.impl.UndoableIntImpl;
import org.openl.ie.constrainer.impl.UndoableOnceImpl;
import org.openl.ie.tools.FastQueue;
import org.openl.ie.tools.FastStack;
import org.openl.ie.tools.FastVector;
import org.openl.ie.tools.RTExceptionWrapper;

public final class Constrainer
implements Serializable {
    public static final double FLOAT_MAX = Double.MAX_VALUE;
    public static final double FLOAT_MIN = 2.225073858507202E-308;
    public static final int INT_MAX = Integer.MAX_VALUE;
    public static final int INT_MIN = Integer.MIN_VALUE;
    public static double FLOAT_PRECISION = 1.0E-6;
    private static double _precision = 1.0E-6;
    private String _name;
    private int _labelsCounter;
    private FastVector _intvars;
    private FastVector _floatvars;
    private FastVector _intsetvars;
    private FastVector _constraints;
    private int _choice_point = 0;
    private GoalStack _goal_stack;
    private UndoStack _reversibility_stack;
    private int _number_of_choice_points = 0;
    private int _number_of_failures = 0;
    private int _number_of_undos = 0;
    private long _time_limit = 0L;
    private long _failures_limit = 0L;
    private FastVector _choice_point_objects;
    private FastVector _failure_objects;
    private boolean _trace_failure_stack;
    private int _failure_display_frequency;
    private FastVector _backtrack_objects;
    private boolean _trace_goals;
    private boolean _show_internal_names;
    private boolean _show_variable_names;
    private long _initial_memory;
    private long _max_occupied_memory;
    private long _number_of_notifications;
    private boolean _print_information;
    private long _execution_time = 0L;
    private FastQueue _propagation_queue;
    private ExpressionFactory _expressionFactory;
    private FastStack _active_undoable_once;
    private transient PrintStream _out = System.out;

    public static void abort(String msg) {
        Constrainer.abort(msg, new RuntimeException(msg));
    }

    public static void abort(String msg, Throwable t) {
        throw RTExceptionWrapper.wrap(msg, t);
    }

    public static double precision() {
        return FLOAT_PRECISION;
    }

    public static void precision(double prc) {
        FLOAT_PRECISION = prc;
    }

    static void printObjects(PrintStream out, String prefix, FastVector objects) {
        int size = objects.size();
        Object[] data = objects.data();
        for (int i = 0; i < size; ++i) {
            out.print(prefix);
            out.println(data[i]);
        }
    }

    public Constrainer(String s) {
        this._max_occupied_memory = this._initial_memory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this._name = s;
        this._active_undoable_once = new FastStack();
        this._intvars = new FastVector();
        this._floatvars = new FastVector();
        this._intsetvars = new FastVector();
        this._constraints = new FastVector();
        this._reversibility_stack = new UndoStack();
        this._goal_stack = new GoalStack(this._reversibility_stack);
        this._propagation_queue = new FastQueue();
        this._show_internal_names = false;
        this._show_variable_names = true;
        this._choice_point = 0;
        this._number_of_choice_points = 0;
        this._number_of_failures = 0;
        this._number_of_notifications = 0L;
        this._failure_display_frequency = 0;
        this._number_of_undos = 0;
        this._choice_point_objects = new FastVector();
        this._failure_objects = new FastVector();
        this._backtrack_objects = new FastVector();
        this._trace_goals = false;
        this._trace_failure_stack = false;
        this._print_information = false;
        this._expressionFactory = new ExpressionFactoryImpl(this);
    }

    public Constraint addConstraint(Constraint ct) {
        this._constraints.addElement(ct);
        this.addUndo(UndoFastVectorAdd.getUndo(this._constraints));
        return ct;
    }

    public Constraint addConstraint(IntBoolExp ctExp) {
        return this.addConstraint(ctExp.asConstraint());
    }

    public FloatVar addFloatVar(double min, double max) throws Failure {
        return this.addFloatVar(min, max, "");
    }

    public FloatVar addFloatVar(double min, double max, String name) {
        FloatVarImpl var = new FloatVarImpl(this, min, max, name);
        return this.addFloatVar(var);
    }

    FloatVar addFloatVar(FloatVar var) {
        this._floatvars.addElement(var);
        this.addUndo(UndoFastVectorAdd.getUndo(this._floatvars));
        return var;
    }

    FloatVar addFloatVarInternal(FloatVar var) {
        this._floatvars.addElement(var);
        this.addUndo(UndoFastVectorAdd.getUndo(this._floatvars));
        return var;
    }

    public FloatVar addFloatVarTrace(double min, double max, String name, int trace) {
        FloatVarImpl var = trace != 0 ? new FloatVarImplTrace(this, min, max, name, trace) : new FloatVarImpl(this, min, max, name);
        return this.addFloatVar(var);
    }

    public FloatVar addFloatVarTraceInternal(double min, double max, String name, int trace) {
        FloatVarImpl var = trace != 0 ? new FloatVarImplTrace(this, min, max, name, trace) : new FloatVarImpl(this, min, max, name);
        return this.addFloatVarInternal(var);
    }

    public IntBoolVar addIntBoolVar() {
        return this.addIntBoolVar("");
    }

    IntBoolVar addIntBoolVar(IntBoolVar var) {
        this._intvars.add(var);
        this.addUndo(UndoFastVectorAdd.getUndo(this._intvars));
        return var;
    }

    public IntBoolVar addIntBoolVar(String name) {
        IntBoolVarImpl var = new IntBoolVarImpl(this, name);
        return this.addIntBoolVar(var);
    }

    IntBoolVar addIntBoolVarInternal(IntBoolVar var) {
        this._intvars.add(var);
        this.addUndo(UndoFastVectorAdd.getUndo(this._intvars));
        return var;
    }

    public IntBoolVar addIntBoolVarInternal(String name) {
        IntBoolVarImpl var = new IntBoolVarImpl(this, name);
        return this.addIntBoolVarInternal(var);
    }

    public IntSetVar addIntSetVar(int[] values) {
        IntSetVarImpl var = new IntSetVarImpl(this, values, "");
        return this.addIntSetVar(var);
    }

    public IntSetVar addIntSetVar(int[] values, String name) {
        IntSetVarImpl var = new IntSetVarImpl(this, values, name);
        return this.addIntSetVar(var);
    }

    IntSetVar addIntSetVar(IntSetVar var) {
        this._intsetvars.addElement(var);
        this.addUndo(UndoFastVectorAdd.getUndo(this._intsetvars));
        return var;
    }

    IntSetVar addIntSetVarInternal(IntSetVar var) {
        this._intsetvars.addElement(var);
        this.addUndo(UndoFastVectorAdd.getUndo(this._intsetvars));
        return var;
    }

    public IntVar addIntVar(int min, int max) {
        return this.addIntVar(min, max, "", -1);
    }

    public IntVar addIntVar(int min, int max, int type) {
        return this.addIntVar(min, max, "", type);
    }

    public IntVar addIntVar(int min, int max, String name) {
        return this.addIntVar(min, max, name, -1);
    }

    public IntVar addIntVar(int min, int max, String name, int type) {
        IntVarImpl var = new IntVarImpl(this, min, max, name, type);
        return this.addIntVar(var);
    }

    public IntVar addIntVar(IntExp exp) {
        IntVar var = this.addIntVar(exp.min(), exp.max());
        try {
            var.equals(exp).post();
        }
        catch (Failure f) {
            Constrainer.abort("Impossible failure in addIntVar(IntExp exp)");
        }
        return var;
    }

    IntVar addIntVar(IntVar var) {
        this._intvars.addElement(var);
        this.addUndo(UndoFastVectorAdd.getUndo(this._intvars));
        return var;
    }

    IntVar addIntVarInternal(IntVar var) {
        this._intvars.addElement(var);
        this.addUndo(UndoFastVectorAdd.getUndo(this._intvars));
        return var;
    }

    public IntVar addIntVarTrace(int min, int max, String name, int type, int trace) {
        IntVarImpl var = trace != 0 ? new IntVarImplTrace(this, min, max, name, type, trace) : new IntVarImpl(this, min, max, name, type);
        return this.addIntVar(var);
    }

    public IntVar addIntVarTraceInternal(int min, int max, String name, int type, int trace) {
        IntVarImpl var = trace != 0 ? new IntVarImplTrace(this, min, max, name, type, trace) : new IntVarImpl(this, min, max, name, type);
        return this.addIntVarInternal(var);
    }

    public void addToPropagationQueue(Subject subject) {
        this._propagation_queue.push(subject);
    }

    public void addUndo(Undo undo_object) {
        ++this._number_of_undos;
        this._reversibility_stack.pushUndo(undo_object);
    }

    public void addUndo(Undo undo_object, Undoable undoable) {
        this.addUndo(undo_object);
        if (undoable instanceof UndoableOnceImpl) {
            this._active_undoable_once.push(undoable);
        }
    }

    public void addUndoableAction(Goal goal) {
        this.addUndo(UndoableAction.getUndo(goal));
        this.allowUndos();
    }

    public UndoableFloat addUndoableFloat(double value) {
        return new UndoableFloatImpl(this, value);
    }

    public UndoableFloat addUndoableFloat(double value, String name) {
        return new UndoableFloatImpl(this, value, name);
    }

    public UndoableInt addUndoableInt(int value) {
        return new UndoableIntImpl(this, value);
    }

    public UndoableInt addUndoableInt(int value, String name) {
        return new UndoableIntImpl(this, value, name);
    }

    public Constraint allDiff(IntExpArray intvars) {
        return new ConstraintAllDiff(intvars);
    }

    void allowUndos() {
        while (!this._active_undoable_once.empty()) {
            ((UndoableOnceImpl)this._active_undoable_once.pop()).restore();
        }
    }

    boolean backtrack() {
        return this.backtrack(null);
    }

    boolean backtrack(ChoicePointLabel label) {
        boolean success = this._goal_stack.backtrack(label);
        this.allowUndos();
        if (success && this._backtrack_objects.size() > 0) {
            Constrainer.printObjects(this._out, "BACKTRACK: ", this._backtrack_objects);
        }
        return success;
    }

    public int getStackSize() {
        return this._reversibility_stack.size();
    }

    public void backtrackStack(int newSize) {
        this._reversibility_stack.backtrack(newSize);
    }

    public IntExp cardinality(IntExpArray intvars, int value) throws Failure {
        return intvars.cards().cardAt(value);
    }

    public IntExp cardinality(IntExpArray array, IntExp exp) throws Failure {
        return new IntExpCardIntExp(array, exp);
    }

    public IntExp cardinality(IntSetVar var) {
        return var.cardinality();
    }

    void clearPropagationQueue() {
        while (!this._propagation_queue.empty()) {
            Subject var = (Subject)this._propagation_queue.pop();
            var.inProcess(false);
        }
    }

    public FastVector constraints() {
        return this._constraints;
    }

    public ChoicePointLabel createChoicePointLabel() {
        ++this._labelsCounter;
        return new ChoicePointLabel(this, this._labelsCounter);
    }

    ChoicePointLabel currentChoicePointLabel() {
        return this._goal_stack.currentChoicePoint().label();
    }

    public IntExpArray distribute(IntExpArray vars) throws Failure {
        int size = vars.size();
        int[] values = new int[size];
        for (int i = 0; i < size; ++i) {
            values[i] = i;
        }
        return this.distribute(vars, values);
    }

    public IntExpArray distribute(IntExpArray vars, int n) throws Failure {
        int[] values = new int[n];
        for (int i = 0; i < n; ++i) {
            values[i] = i;
        }
        return this.distribute(vars, values);
    }

    public IntExpArray distribute(IntExpArray vars, int[] values) throws Failure {
        IntArrayCards vcards = vars.cards();
        FastVector cards = new FastVector();
        for (int i = 0; i < values.length; ++i) {
            cards.addElement(vcards.cardAt(values[i]));
        }
        return new IntExpArray(this, cards);
    }

    public IntArrayCards distribute(IntExpArray vars, IntExpArray cards) throws Failure {
        IntArrayCards vcards = vars.cards();
        for (int i = 0; i < vcards.cardSize(); ++i) {
            Constraint ct = vcards.cardAt(i).equals(cards.get(i));
            ct.execute();
        }
        return vcards;
    }

    void doPrintInformation() {
        this._out.println("\nChoice Points: " + this._number_of_choice_points + "  Failures: " + this._number_of_failures + "  Undos: " + this._number_of_undos + "  Notifications: " + this._number_of_notifications + "  Memory: " + (this._max_occupied_memory - this._initial_memory) + "  Time: " + this._execution_time + "msec");
    }

    public boolean execute(Goal goal) {
        return this.execute(goal, false);
    }

    public synchronized boolean execute(Goal main_goal, boolean restore_flag) {
        boolean restoreAnyway;
        long execution_start = System.currentTimeMillis();
        boolean success = true;
        long start_seconds = System.currentTimeMillis() / 1000L;
        GoalStack old_goal_stack = this._goal_stack;
        this._goal_stack = new GoalStack(main_goal, this._reversibility_stack);
        this.allowUndos();
        while (!this._goal_stack.empty()) {
            long occupied_memory;
            try {
                Goal goal = this._goal_stack.popGoal();
                if (this._trace_goals) {
                    this._out.println("Execute: " + goal);
                }
                goal = goal.execute();
                this.propagate();
                if (this._print_information && this._max_occupied_memory < (occupied_memory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) {
                    this._max_occupied_memory = occupied_memory;
                }
                if (goal == null) continue;
                this._goal_stack.pushGoal(goal);
            }
            catch (Failure f) {
                long now_seconds;
                if (this._trace_failure_stack && this._failure_display_frequency > 0 && this._number_of_failures % this._failure_display_frequency == 0) {
                    f.printStackTrace(this._out);
                }
                if (this._print_information && this._max_occupied_memory < (occupied_memory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) {
                    this._max_occupied_memory = occupied_memory;
                }
                this.clearPropagationQueue();
                if (this._time_limit > 0L && (now_seconds = System.currentTimeMillis() / 1000L) - start_seconds > this._time_limit) {
                    throw new TimeLimitException("Time limit exceeded", f.label());
                }
                if (this._failures_limit > 0L && (long)this._number_of_failures > this._failures_limit) {
                    this._out.println("Failures Limit Violation: more than " + this._failures_limit);
                    success = false;
                    break;
                }
                if (this.backtrack(f.label())) continue;
                success = false;
                break;
            }
            catch (Throwable t) {
                this._out.println("Unexpected exception: " + t.toString());
                t.printStackTrace(this._out);
                Constrainer.abort("Unexpected exception: ", t);
            }
        }
        boolean bl = restoreAnyway = restore_flag || !success;
        if (restoreAnyway) {
            this.backtrackStack(this._goal_stack.undoStackSize());
        }
        this._execution_time += System.currentTimeMillis() - execution_start;
        if (this._print_information && !(main_goal instanceof Constraint)) {
            this.doPrintInformation();
        }
        this._goal_stack = old_goal_stack;
        return success;
    }

    public boolean execute(Goal main_goal, int solution_number) {
        return this.execute(main_goal, solution_number, false);
    }

    public boolean execute(Goal main_goal, int solution_number, boolean restore_flag) {
        GoalAnd goal = new GoalAnd(main_goal, new GoalCheckSolutionNumber(this, solution_number));
        return this.execute((Goal)goal, restore_flag);
    }

    public boolean executeAll(Goal main_goal) {
        GoalAllSolutions all_solutions = new GoalAllSolutions(main_goal);
        return this.execute(all_solutions);
    }

    public long executionTime() {
        return this._execution_time;
    }

    public ExpressionFactory expressionFactory() {
        return this._expressionFactory;
    }

    public void fail() throws Failure {
        this.fail("");
    }

    public void fail(String s) throws Failure {
        this.fail(s, null);
    }

    public void fail(String s, ChoicePointLabel label) throws Failure {
        ++this._number_of_failures;
        if (this._failure_display_frequency > 0 && this._number_of_failures % this._failure_display_frequency == 0) {
            this._out.println("Failure " + this._number_of_failures + ": " + s);
        }
        if (this._failure_display_frequency == 0 || this._number_of_failures % this._failure_display_frequency == 0) {
            for (int i = 0; i < this._failure_objects.size(); ++i) {
                this._out.println("Failure: " + s + " " + this._failure_objects.elementAt(i));
            }
        }
        throw new Failure(s, label);
    }

    int[] findAppropriate(FloatVar[] floatVars) {
        if (floatVars == null) {
            return null;
        }
        int size = floatVars.length;
        int[] indices = new int[size];
        HashMap<Object, Integer> map = new HashMap<Object, Integer>(size);
        Object[] vars = this._floatvars.data();
        for (int i = 0; i < vars.length; ++i) {
            map.put(vars[i], new Integer(i));
        }
        int validsCounter = 0;
        for (int i = 0; i < size; ++i) {
            Integer idx = (Integer)map.get(floatVars[i]);
            if (idx == null) continue;
            indices[validsCounter] = idx;
            ++validsCounter;
        }
        int[] out = new int[validsCounter];
        System.arraycopy(indices, 0, out, 0, validsCounter);
        return out;
    }

    int[] findAppropriate(IntVar[] intVars) {
        if (intVars == null) {
            return null;
        }
        int size = intVars.length;
        int[] indices = new int[size];
        HashMap<Object, Integer> map = new HashMap<Object, Integer>(size);
        Object[] vars = this._intvars.data();
        for (int i = 0; i < vars.length; ++i) {
            map.put(vars[i], new Integer(i));
        }
        int validsCounter = 0;
        for (int i = 0; i < size; ++i) {
            Integer idx = (Integer)map.get(intVars[i]);
            if (idx == null) continue;
            indices[validsCounter] = idx;
            ++validsCounter;
        }
        int[] out = new int[validsCounter];
        System.arraycopy(indices, 0, out, 0, validsCounter);
        return out;
    }

    public FastVector floats() {
        return this._floatvars;
    }

    FloatVar[] getFloatVars(int[] indices) {
        if (indices == null) {
            return null;
        }
        FloatVar[] ari = new FloatVar[indices.length];
        Object[] vars = this._floatvars.data();
        for (int i = 0; i < indices.length; ++i) {
            ari[i] = (FloatVar)vars[indices[i]];
        }
        return ari;
    }

    IntVar[] getIntVars(int[] indices) {
        if (indices == null) {
            return null;
        }
        IntVar[] ari = new IntVar[indices.length];
        Object[] vars = this._intvars.data();
        for (int i = 0; i < indices.length; ++i) {
            ari[i] = (IntVar)vars[indices[i]];
        }
        return ari;
    }

    public int getSolutionsNumber(Goal main_goal, int max_sol) {
        GoalCheckSolutionNumber check = new GoalCheckSolutionNumber(this, max_sol);
        GoalAnd goal = new GoalAnd(main_goal, check);
        if (this.execute((Goal)goal, true)) {
            return max_sol;
        }
        return check.getCurrentSolutionNumber();
    }

    Goal GoalPostConstraints(Object[] constraints) {
        Goal g = null;
        for (int i = 0; i < constraints.length; ++i) {
            Constraint ct;
            Object o = constraints[i];
            if (o instanceof Constraint) {
                ct = (Constraint)o;
            } else if (o instanceof IntBoolExp) {
                ct = ((IntBoolExp)o).asConstraint();
            } else {
                throw new RuntimeException("Not a constraint: " + o);
            }
            if (ct == null) continue;
            g = i == 0 ? ct : new GoalAnd(g, ct);
        }
        return g;
    }

    public void incrementNumberOfNotifications() {
        ++this._number_of_notifications;
    }

    public FastVector integers() {
        return this._intvars;
    }

    public IntSetVar intersection(IntSetVar var1, IntSetVar var2) {
        return var1.intersectionWith(var2);
    }

    public Constraint nullIntersect(IntSetVar var1, IntSetVar var2) {
        return var1.nullIntersectWith(var2);
    }

    public int numberOfChoicePoints() {
        return this._number_of_choice_points;
    }

    public void numberOfChoicePoints(int cps) {
        this._number_of_choice_points = cps;
    }

    public int numberOfFailures() {
        return this._number_of_failures;
    }

    public void numberOfFailures(int nfs) {
        this._number_of_failures = nfs;
    }

    public long numberOfNotifications() {
        return this._number_of_notifications;
    }

    public PrintStream out() {
        return this._out;
    }

    public void out(PrintStream out) {
        this._out = out;
    }

    public void postConstraint(Constraint ct) throws Failure {
        boolean ok = this.execute(ct);
        if (!ok) {
            String s = "Posting of constraint failed: " + ct;
            throw new Failure(s);
        }
    }

    public void postConstraint(IntBoolExp ct) throws Failure {
        this.postConstraint(ct.asConstraint());
    }

    public void postConstraints() throws Failure {
        this.postConstraints(this._constraints.toArray());
    }

    void postConstraints(Object[] constraints) throws Failure {
        Goal g = this.GoalPostConstraints(constraints);
        if (g == null) {
            return;
        }
        boolean ok = this.execute(g);
        if (!ok) {
            String s = constraints.length == 1 ? "Posting of constraint failed: " + constraints[0] : "Posting of " + constraints.length + " constraints failed";
            throw new Failure(s);
        }
    }

    public void printInformation() {
        this._print_information = true;
    }

    public final void propagate() throws Failure {
        while (!this._propagation_queue.empty()) {
            Subject var = (Subject)this._propagation_queue.pop();
            var.inProcess(false);
            var.propagate();
        }
    }

    void pushOnExecutionStack(Goal goal) {
        this._goal_stack.pushGoal(goal);
    }

    public FloatExp scalarProduct(FloatExpArray exps, double[] values) {
        int size = exps.size();
        if (values.length != size) {
            throw new RuntimeException("scalarProduct parameters have different size");
        }
        FloatExpArray products = new FloatExpArray(this, size);
        for (int i = 0; i < size; ++i) {
            products.set(exps.elementAt(i).mul(values[i]), i);
        }
        return products.sum();
    }

    public FloatExp scalarProduct(IntExpArray exps, double[] values) {
        int size = exps.size();
        if (values.length != size) {
            throw new RuntimeException("scalarProduct parameters have different size");
        }
        FloatExpArray products = new FloatExpArray(this, size);
        for (int i = 0; i < size; ++i) {
            products.set(exps.elementAt(i).mul(values[i]), i);
        }
        return products.sum();
    }

    public IntExp scalarProduct(IntExpArray exps, int[] values) {
        int size = exps.size();
        if (values.length != size) {
            throw new RuntimeException("scalarProduct parameters have different size");
        }
        IntExpArray products = new IntExpArray(this, size);
        for (int i = 0; i < size; ++i) {
            products.set(exps.elementAt(i).mul(values[i]), i);
        }
        return products.sum();
    }

    void setChoicePoint(Goal g1, Goal g2) {
        this.setChoicePoint(g1, g2, null);
    }

    void setChoicePoint(Goal g1, Goal g2, ChoicePointLabel label) {
        ++this._number_of_choice_points;
        this._goal_stack.setChoicePoint(g1, g2, label);
        this.allowUndos();
        if (this._choice_point_objects.size() > 0) {
            Constrainer.printObjects(this._out, "CP " + (this._choice_point - 1) + ":", this._choice_point_objects);
        }
    }

    public void setFailuresLimit(long nf) {
        this._failures_limit = nf;
    }

    public void setTimeLimit(long seconds) {
        this._time_limit = seconds;
    }

    public boolean showFailures() {
        return this._failure_display_frequency > 0;
    }

    public boolean showInternalNames() {
        return this._show_internal_names;
    }

    public void showInternalNames(boolean flag) {
        this._show_internal_names = flag;
    }

    public boolean showVariableNames() {
        return this._show_variable_names;
    }

    public void showVariableNames(boolean flag) {
        this._show_variable_names = flag;
    }

    public IntExp sum(IntExp var1, IntExp var2) {
        return var1.add(var2);
    }

    public IntExp sum(IntExpArray vars) {
        return vars.sum();
    }

    public synchronized boolean toContinue(ChoicePointLabel label, boolean restore_flag) {
        boolean restoreAnyway;
        long execution_start = System.currentTimeMillis();
        boolean success = true;
        long start_seconds = System.currentTimeMillis() / 1000L;
        GoalStack old_goal_stack = this._goal_stack;
        this.allowUndos();
        if (!this.backtrack(label)) {
            success = false;
        }
        if (success) {
            while (!this._goal_stack.empty()) {
                long occupied_memory;
                try {
                    Goal goal = this._goal_stack.popGoal();
                    if (this._trace_goals) {
                        this._out.println("Execute: " + goal);
                    }
                    goal = goal.execute();
                    this.propagate();
                    if (this._print_information && this._max_occupied_memory < (occupied_memory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) {
                        this._max_occupied_memory = occupied_memory;
                    }
                    if (goal == null) continue;
                    this._goal_stack.pushGoal(goal);
                }
                catch (Failure f) {
                    long now_seconds;
                    if (this._trace_failure_stack && this._failure_display_frequency > 0 && this._number_of_failures % this._failure_display_frequency == 0) {
                        f.printStackTrace(this._out);
                    }
                    if (this._print_information && this._max_occupied_memory < (occupied_memory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) {
                        this._max_occupied_memory = occupied_memory;
                    }
                    this.clearPropagationQueue();
                    if (this._time_limit > 0L && (now_seconds = System.currentTimeMillis() / 1000L) - start_seconds > this._time_limit) {
                        throw new TimeLimitException("time limit", f.label());
                    }
                    if (this._failures_limit > 0L && (long)this._number_of_failures > this._failures_limit) {
                        this._out.println("Failures Limit Violation: more than " + this._failures_limit);
                        success = false;
                        break;
                    }
                    if (this.backtrack(f.label())) continue;
                    success = false;
                    break;
                }
                catch (Throwable t) {
                    this._out.println("Unexpected exception: " + t.toString());
                    t.printStackTrace(this._out);
                    Constrainer.abort("Unexpected exception: ", t);
                }
            }
        }
        boolean bl = restoreAnyway = restore_flag || !success;
        if (restoreAnyway) {
            this.backtrackStack(this._goal_stack.undoStackSize());
        }
        this._execution_time += System.currentTimeMillis() - execution_start;
        this._goal_stack = old_goal_stack;
        return success;
    }

    public String toString() {
        return "Constrainer: " + this._name + "\n" + this._goal_stack + "\n" + this._reversibility_stack;
    }

    public void trace(IntExpArray vars) {
        class ObserverTraceVars
        extends Observer {
            private IntExpArray _vars;

            ObserverTraceVars(IntExpArray vars) {
                this._vars = vars;
            }

            @Override
            public Object master() {
                return Constrainer.this;
            }

            @Override
            public int subscriberMask() {
                return 15;
            }

            @Override
            public void update(Subject var, EventOfInterest interest) throws Failure {
                Constrainer.this._out.println("Trace " + interest + ": " + this._vars);
            }
        }
        ObserverTraceVars observer = new ObserverTraceVars(vars);
        for (int i = 0; i < vars.size(); ++i) {
            IntExp var = vars.get(i);
            var.attachObserver(observer);
        }
    }

    public void trace(Subject subject) {
        subject.trace();
    }

    public void traceBacktracks(Object obj) {
        this._backtrack_objects.addElement(obj);
    }

    public void traceChoicePoints(Object obj) {
        this._choice_point_objects.addElement(obj);
    }

    public void traceExecution() {
        this.showInternalNames(true);
        this._trace_goals = true;
    }

    public void traceFailures() {
        this.traceFailures(1);
    }

    public void traceFailures(int frequency) {
        this.traceFailures(frequency, null);
    }

    public void traceFailures(int frequency, Object obj) {
        this._failure_display_frequency = frequency;
        if (obj != null) {
            this._failure_objects.addElement(obj);
        }
    }

    public void traceFailures(Object obj) {
        this.traceFailures(1, obj);
    }

    public void traceFailureStack() {
        this._trace_failure_stack = true;
    }

    public void traceOff() {
        this.showInternalNames(false);
        this._trace_goals = false;
        this._backtrack_objects.clear();
        this._choice_point_objects.clear();
        this._failure_objects.clear();
        this._trace_failure_stack = false;
        this._failure_display_frequency = 0;
    }

    public IntSetVar union(IntSetVar var1, IntSetVar var2) {
        return var1.unionWith(var2);
    }
}

