/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.consistencyChecking;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.openl.ie.constrainer.Constrainer;
import org.openl.ie.constrainer.Constraint;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.Goal;
import org.openl.ie.constrainer.GoalAnd;
import org.openl.ie.constrainer.GoalGenerate;
import org.openl.ie.constrainer.GoalImpl;
import org.openl.ie.constrainer.IntBoolExp;
import org.openl.ie.constrainer.IntExp;
import org.openl.ie.constrainer.IntExpArray;
import org.openl.ie.constrainer.consistencyChecking.CDecisionTable;
import org.openl.ie.constrainer.consistencyChecking.IntPair;
import org.openl.ie.constrainer.consistencyChecking.Overlapping;
import org.openl.ie.constrainer.consistencyChecking.OverlappingChecker;

public class OverlappingCheckerImpl2
implements OverlappingChecker {
    private static final int MAX_OVERLOADS = 50;
    private CDecisionTable _dt = null;
    List<Overlapping> overlappings = new ArrayList<Overlapping>();
    HashSet<IntPair> checkedPairs = new HashSet();
    boolean[] removed;
    boolean[] hadBeenRemoved;
    int nRemoved = 0;

    private void remove(int i) {
        this.removed[i] = true;
        ++this.nRemoved;
    }

    private void restore(int i) {
        this.removed[i] = false;
        --this.nRemoved;
    }

    public OverlappingCheckerImpl2(CDecisionTable _dt) {
        this._dt = _dt;
        this.removed = new boolean[_dt.getRules().length];
        this.hadBeenRemoved = new boolean[_dt.getRules().length];
    }

    public void checkInternal() {
        if (this.overlappings.size() > 50) {
            return;
        }
        ArrayList<Overlapping> overlappingRules = new ArrayList<Overlapping>();
        IntBoolExp[] rules = this._dt.getRules();
        Constrainer C = rules[0].constrainer();
        int stackSize = C.getStackSize();
        IntExpArray ruleArray = new IntExpArray(C, rules.length - this.nRemoved);
        int r = 0;
        for (int i = 0; i < rules.length; ++i) {
            if (this.removed[i]) continue;
            ruleArray.set(rules[i], r++);
        }
        Constraint overlapping = ruleArray.sum().gt(1).asConstraint();
        GoalSaveSolutions save = new GoalSaveSolutions(C, overlappingRules);
        GoalGenerate generate = new GoalGenerate(this._dt.getVars());
        GoalAnd target = new GoalAnd(new GoalAnd(overlapping, generate), save);
        C.execute((Goal)target, true);
        C.backtrackStack(stackSize);
        this.testPairOverlappings(overlappingRules);
    }

    private void testPairOverlappings(List<Overlapping> overlappingRules) {
        for (Overlapping ovl : overlappingRules) {
            int[] rules = ovl.getOverlapped();
            for (int i = 0; i < rules.length; ++i) {
                for (int j = i + 1; j < rules.length; ++j) {
                    int B;
                    IntPair pair = new IntPair(rules[i], rules[j]);
                    if (this.checkedPairs.contains(pair)) continue;
                    this.checkedPairs.add(pair);
                    int A = this._dt.isOverrideAscending() ? i : j;
                    int n = B = this._dt.isOverrideAscending() ? j : i;
                    if (this.completelyOverlaps(this._dt.getRule(rules[A]), this._dt.getRule(rules[B]))) {
                        this.overlappings.add(new Overlapping(ovl, rules[A], rules[B], Overlapping.OverlappingStatus.BLOCK));
                    } else if (this.completelyOverlaps(this._dt.getRule(rules[B]), this._dt.getRule(rules[A]))) {
                        this.overlappings.add(new Overlapping(ovl, rules[A], rules[B], Overlapping.OverlappingStatus.OVERRIDE));
                    } else {
                        this.overlappings.add(new Overlapping(ovl, rules[A], rules[B], Overlapping.OverlappingStatus.PARTIAL));
                    }
                    this.checkWithRemove(rules[A]);
                    this.checkWithRemove(rules[B]);
                }
            }
        }
    }

    private void checkWithRemove(int ind) {
        if (this.hadBeenRemoved[ind]) {
            return;
        }
        this.hadBeenRemoved[ind] = true;
        this.remove(ind);
        this.checkInternal();
        this.restore(ind);
    }

    private boolean completelyOverlaps(IntExp exp1, IntExp exp2) {
        Constrainer C = exp1.constrainer();
        int stackSize = C.getStackSize();
        Constraint overlaps = exp1.sub(exp2).lt(0).asConstraint();
        GoalGenerate generate = new GoalGenerate(this._dt.getVars());
        GoalAnd target = new GoalAnd(overlaps, generate);
        boolean flag = C.execute((Goal)target, true);
        C.backtrackStack(stackSize);
        return !flag;
    }

    @Override
    public List<Overlapping> check() {
        this.checkInternal();
        return this.overlappings;
    }

    private class GoalSaveSolutions
    extends GoalImpl {
        private static final long serialVersionUID = 4298252562811799305L;
        List<Overlapping> overlappingRules;

        public GoalSaveSolutions(Constrainer c, List<Overlapping> ovlRules) {
            super(c);
            this.overlappingRules = ovlRules;
        }

        @Override
        public Goal execute() throws Failure {
            Overlapping over = new Overlapping(OverlappingCheckerImpl2.this._dt.getVars());
            for (int i = 0; i < OverlappingCheckerImpl2.this._dt.getRules().length; ++i) {
                IntBoolExp rule;
                if (OverlappingCheckerImpl2.this.removed[i] || !(rule = OverlappingCheckerImpl2.this._dt.getRule(i)).bound() || rule.max() != 1) continue;
                over.addRule(i);
            }
            if (over.amount() > 0) {
                this.overlappingRules.add(over);
            }
            return null;
        }
    }
}

