/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.FloatVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.FloatExpImpl;

public final class FloatExpAbs
extends FloatExpImpl {
    private FloatExp _exp;
    private Observer _observer;
    private FloatVar _abs;

    static double abs_max(double min, double max) {
        if (min >= 0.0) {
            return max;
        }
        if (max <= 0.0) {
            return -min;
        }
        return Math.max(-min, max);
    }

    static double abs_min(double min, double max) {
        if (min >= 0.0) {
            return min;
        }
        if (max >= 0.0) {
            return 0.0;
        }
        return -max;
    }

    public FloatExpAbs(FloatExp exp) {
        super(exp.constrainer());
        this._exp = exp;
        this._observer = new FloatExpAbsObserver();
        this._exp.attachObserver(this._observer);
        if (this.constrainer().showInternalNames()) {
            this._name = "|" + exp.name() + "|";
        }
        int trace = 0;
        double min = this._exp.min();
        double max = this._exp.max();
        this._abs = this.constrainer().addFloatVarTraceInternal(FloatExpAbs.abs_min(min, max), FloatExpAbs.abs_max(min, max), this._name, trace);
    }

    @Override
    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._abs.attachObserver(observer);
    }

    @Override
    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._abs.detachObserver(observer);
    }

    @Override
    public double max() {
        return this._abs.max();
    }

    @Override
    public double min() {
        return this._abs.min();
    }

    @Override
    public void onMaskChange() {
    }

    @Override
    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._abs.reattachObserver(observer);
    }

    @Override
    public void setMax(double max) throws Failure {
        this._abs.setMax(max);
        this._exp.setMax(max);
        this._exp.setMin(-max);
    }

    @Override
    public void setMin(double min) throws Failure {
        if (min <= 0.0) {
            return;
        }
        this._abs.setMin(min);
        double removeMax = min;
        this._exp.removeRange(-removeMax, removeMax);
    }

    @Override
    public void setValue(double value) throws Failure {
        this._abs.setValue(value);
        this.setMax(value);
        this.setMin(value);
    }

    @Override
    public String toString() {
        return "|" + this._exp + "|" + this.domainToString();
    }

    class FloatExpAbsObserver
    extends ExpressionObserver {
        FloatExpAbsObserver() {
        }

        @Override
        public Object master() {
            return FloatExpAbs.this;
        }

        @Override
        public int subscriberMask() {
            return 7;
        }

        @Override
        public String toString() {
            return "FloatExpAbsObserver: " + FloatExpAbs.this._exp;
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            FloatEvent e = (FloatEvent)event;
            double min = e.min();
            double max = e.max();
            FloatExpAbs.this._abs.setMin(FloatExpAbs.abs_min(min, max));
            FloatExpAbs.this._abs.setMax(FloatExpAbs.abs_max(min, max));
        }
    }
}

