/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.FloatVar;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.FloatCalc;
import org.openl.ie.constrainer.impl.FloatExpImpl;

public final class FloatExpMulExp
extends FloatExpImpl {
    private FloatExp _exp1;
    private FloatExp _exp2;
    private Observer _observer;
    private FloatVar _product;
    private FloatExpMulExpCalc _calc;

    public FloatExpMulExp(FloatExp exp1, FloatExp exp2) {
        super(exp1.constrainer(), "");
        if (this.constrainer().showInternalNames()) {
            this._name = exp1.name() + "*" + exp2.name();
        }
        this._exp1 = exp1;
        this._exp2 = exp2;
        this.createCalc();
        this._calc.createProduct();
        this._observer = new FloatExpMulExpObserver();
        this._exp1.attachObserver(this._observer);
        this._exp2.attachObserver(this._observer);
    }

    @Override
    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._product.attachObserver(observer);
    }

    @Override
    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        if (this._exp1.bound()) {
            return this._exp2.calcCoeffs(map, factor * this._exp1.max());
        }
        if (this._exp2.bound()) {
            return this._exp1.calcCoeffs(map, factor * this._exp2.max());
        }
        throw new NonLinearExpression(this);
    }

    void createCalc() {
        this._calc = this._exp1.min() >= 0.0 ? (this._exp2.min() >= 0.0 ? new CalcPP(this._exp1, this._exp2) : (this._exp2.max() <= 0.0 ? new CalcPN(this._exp1, this._exp2) : new CalcP(this._exp1, this._exp2))) : (this._exp1.max() <= 0.0 ? (this._exp2.min() >= 0.0 ? new CalcPN(this._exp2, this._exp1) : (this._exp2.max() <= 0.0 ? new CalcNN(this._exp1, this._exp2) : new CalcN(this._exp1, this._exp2))) : (this._exp2.min() >= 0.0 ? new CalcP(this._exp2, this._exp1) : (this._exp2.max() <= 0.0 ? new CalcN(this._exp2, this._exp1) : new CalcGeneral(this._exp1, this._exp2))));
    }

    void createProductVar(double min, double max) {
        int trace = 0;
        this._product = this.constrainer().addFloatVarTraceInternal(min, max, this._name, trace);
    }

    @Override
    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._product.detachObserver(observer);
    }

    @Override
    public boolean isLinear() {
        if (!this._exp1.bound() && !this._exp2.bound()) {
            return false;
        }
        return this._exp1.isLinear() && this._exp2.isLinear();
    }

    @Override
    public double max() {
        return this._product.max();
    }

    @Override
    public double min() {
        return this._product.min();
    }

    @Override
    public void name(String name) {
        super.name(name);
        this._product.name(name);
    }

    @Override
    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._product.reattachObserver(observer);
    }

    @Override
    public void setMax(double max) throws Failure {
        if (max >= this.max()) {
            return;
        }
        this._product.setMax(max);
        this._calc.setMax(max);
    }

    @Override
    public void setMin(double min) throws Failure {
        if (min <= this.min()) {
            return;
        }
        this._product.setMin(min);
        this._calc.setMin(min);
    }

    @Override
    public void setValue(double value) throws Failure {
        this.setMin(value);
        this.setMax(value);
    }

    void updateProductVar(double min, double max) throws Failure {
        this._product.setMin(min);
        this._product.setMax(max);
    }

    final class FloatExpMulExpObserver
    extends Observer {
        FloatExpMulExpObserver() {
        }

        @Override
        public Object master() {
            return FloatExpMulExp.this;
        }

        @Override
        public int subscriberMask() {
            return 7;
        }

        public String toString() {
            return "FloatExpMulExpObserver: " + FloatExpMulExp.this._exp1 + " x " + FloatExpMulExp.this._exp2;
        }

        @Override
        public void update(Subject subject, EventOfInterest event) throws Failure {
            FloatExpMulExp.this._calc.updateFromObserver();
        }
    }

    abstract class FloatExpMulExpCalc {
        FloatExpMulExpCalc() {
        }

        public void createProduct() {
            FloatExpMulExp.this.createProductVar(this.min(), this.max());
        }

        public abstract double max();

        public abstract double min();

        public abstract void setMax(double var1) throws Failure;

        public abstract void setMin(double var1) throws Failure;

        public void updateFromObserver() throws Failure {
            FloatExpMulExp.this.updateProductVar(this.min(), this.max());
        }
    }

    final class CalcPP
    extends FloatExpMulExpCalc {
        private FloatExp _exp1;
        private FloatExp _exp2;

        public CalcPP(FloatExp exp1, FloatExp exp2) {
            this._exp1 = exp1;
            this._exp2 = exp2;
        }

        @Override
        public double max() {
            return this._exp1.max() * this._exp2.max();
        }

        @Override
        public double min() {
            return this._exp1.min() * this._exp2.min();
        }

        @Override
        public void setMax(double max) throws Failure {
            FloatCalc.productSetMaxP(max, this._exp1.min(), this._exp1.max(), this._exp2);
            FloatCalc.productSetMaxP(max, this._exp2.min(), this._exp2.max(), this._exp1);
        }

        @Override
        public void setMin(double min) throws Failure {
            FloatCalc.productSetMinP(min, this._exp1.min(), this._exp1.max(), this._exp2);
            FloatCalc.productSetMinP(min, this._exp2.min(), this._exp2.max(), this._exp1);
        }
    }

    final class CalcPN
    extends FloatExpMulExpCalc {
        private FloatExp _exp1;
        private FloatExp _exp2;

        public CalcPN(FloatExp exp1, FloatExp exp2) {
            this._exp1 = exp1;
            this._exp2 = exp2;
        }

        @Override
        public double max() {
            return this._exp1.min() * this._exp2.max();
        }

        @Override
        public double min() {
            return this._exp1.max() * this._exp2.min();
        }

        @Override
        public void setMax(double max) throws Failure {
            FloatCalc.productSetMaxP(max, this._exp1.min(), this._exp1.max(), this._exp2);
            FloatCalc.productSetMaxN(max, this._exp2.min(), this._exp2.max(), this._exp1);
        }

        @Override
        public void setMin(double min) throws Failure {
            FloatCalc.productSetMinP(min, this._exp1.min(), this._exp1.max(), this._exp2);
            FloatCalc.productSetMinN(min, this._exp2.min(), this._exp2.max(), this._exp1);
        }
    }

    final class CalcP
    extends FloatExpMulExpCalc {
        private FloatExp _exp1;
        private FloatExp _exp2;

        public CalcP(FloatExp exp1, FloatExp exp2) {
            this._exp1 = exp1;
            this._exp2 = exp2;
        }

        @Override
        public void createProduct() {
            double min1 = this._exp1.min();
            double max1 = this._exp1.max();
            double min2 = this._exp2.min();
            double max2 = this._exp2.max();
            double min = FloatCalc.productMinP(min1, max1, min2);
            double max = FloatCalc.productMaxP(min1, max1, max2);
            FloatExpMulExp.this.createProductVar(min, max);
        }

        @Override
        public double max() {
            return FloatCalc.productMaxP(this._exp1.min(), this._exp1.max(), this._exp2.max());
        }

        @Override
        public double min() {
            return FloatCalc.productMinP(this._exp1.min(), this._exp1.max(), this._exp2.min());
        }

        @Override
        public void setMax(double max) throws Failure {
            double min1 = this._exp1.min();
            double max1 = this._exp1.max();
            FloatCalc.productSetMaxP(max, min1, max1, this._exp2);
            FloatCalc.productSetMax(max, this._exp2, this._exp1);
        }

        @Override
        public void setMin(double min) throws Failure {
            double min1 = this._exp1.min();
            double max1 = this._exp1.max();
            FloatCalc.productSetMinP(min, min1, max1, this._exp2);
            FloatCalc.productSetMin(min, this._exp2, this._exp1);
        }

        @Override
        public void updateFromObserver() throws Failure {
            double min1 = this._exp1.min();
            double max1 = this._exp1.max();
            double min2 = this._exp2.min();
            double max2 = this._exp2.max();
            double min = FloatCalc.productMinP(min1, max1, min2);
            double max = FloatCalc.productMaxP(min1, max1, max2);
            FloatExpMulExp.this.updateProductVar(min, max);
        }
    }

    final class CalcNN
    extends FloatExpMulExpCalc {
        private FloatExp _exp1;
        private FloatExp _exp2;

        public CalcNN(FloatExp exp1, FloatExp exp2) {
            this._exp1 = exp1;
            this._exp2 = exp2;
        }

        @Override
        public double max() {
            return this._exp1.min() * this._exp2.min();
        }

        @Override
        public double min() {
            return this._exp1.max() * this._exp2.max();
        }

        @Override
        public void setMax(double max) throws Failure {
            FloatCalc.productSetMaxN(max, this._exp1.min(), this._exp1.max(), this._exp2);
            FloatCalc.productSetMaxN(max, this._exp2.min(), this._exp2.max(), this._exp1);
        }

        @Override
        public void setMin(double min) throws Failure {
            FloatCalc.productSetMinN(min, this._exp1.min(), this._exp1.max(), this._exp2);
            FloatCalc.productSetMinN(min, this._exp2.min(), this._exp2.max(), this._exp1);
        }
    }

    final class CalcN
    extends FloatExpMulExpCalc {
        private FloatExp _exp1;
        private FloatExp _exp2;

        public CalcN(FloatExp exp1, FloatExp exp2) {
            this._exp1 = exp1;
            this._exp2 = exp2;
        }

        @Override
        public void createProduct() {
            double min1 = this._exp1.min();
            double max1 = this._exp1.max();
            double min2 = this._exp2.min();
            double max2 = this._exp2.max();
            double min = FloatCalc.productMinN(min1, max1, max2);
            double max = FloatCalc.productMaxN(min1, max1, min2);
            FloatExpMulExp.this.createProductVar(min, max);
        }

        @Override
        public double max() {
            return FloatCalc.productMaxN(this._exp1.min(), this._exp1.max(), this._exp2.min());
        }

        @Override
        public double min() {
            return FloatCalc.productMinN(this._exp1.min(), this._exp1.max(), this._exp2.max());
        }

        @Override
        public void setMax(double max) throws Failure {
            double min1 = this._exp1.min();
            double max1 = this._exp1.max();
            FloatCalc.productSetMaxN(max, min1, max1, this._exp2);
            FloatCalc.productSetMax(max, this._exp2, this._exp1);
        }

        @Override
        public void setMin(double min) throws Failure {
            double min1 = this._exp1.min();
            double max1 = this._exp1.max();
            FloatCalc.productSetMinN(min, min1, max1, this._exp2);
            FloatCalc.productSetMin(min, this._exp2, this._exp1);
        }

        @Override
        public void updateFromObserver() throws Failure {
            double min1 = this._exp1.min();
            double max1 = this._exp1.max();
            double min2 = this._exp2.min();
            double max2 = this._exp2.max();
            double min = FloatCalc.productMinN(min1, max1, max2);
            double max = FloatCalc.productMaxN(min1, max1, min2);
            FloatExpMulExp.this.updateProductVar(min, max);
        }
    }

    final class CalcGeneral
    extends FloatExpMulExpCalc {
        private FloatExp _exp1;
        private FloatExp _exp2;

        public CalcGeneral(FloatExp exp1, FloatExp exp2) {
            this._exp1 = exp1;
            this._exp2 = exp2;
        }

        @Override
        public void createProduct() {
            double min1 = this._exp1.min();
            double max1 = this._exp1.max();
            double min2 = this._exp2.min();
            double max2 = this._exp2.max();
            double min = FloatCalc.productMin(min1, max1, min2, max2);
            double max = FloatCalc.productMax(min1, max1, min2, max2);
            FloatExpMulExp.this.createProductVar(min, max);
        }

        @Override
        public double max() {
            return FloatCalc.productMax(this._exp1.min(), this._exp1.max(), this._exp2.min(), this._exp2.max());
        }

        @Override
        public double min() {
            return FloatCalc.productMin(this._exp1.min(), this._exp1.max(), this._exp2.min(), this._exp2.max());
        }

        @Override
        public void setMax(double max) throws Failure {
            FloatCalc.productSetMax(max, this._exp1, this._exp2);
            FloatCalc.productSetMax(max, this._exp2, this._exp1);
        }

        @Override
        public void setMin(double min) throws Failure {
            FloatCalc.productSetMin(min, this._exp1, this._exp2);
            FloatCalc.productSetMin(min, this._exp2, this._exp1);
        }

        @Override
        public void updateFromObserver() throws Failure {
            double min1 = this._exp1.min();
            double max1 = this._exp1.max();
            double min2 = this._exp2.min();
            double max2 = this._exp2.max();
            double min = FloatCalc.productMin(min1, max1, min2, max2);
            double max = FloatCalc.productMax(min1, max1, min2, max2);
            FloatExpMulExp.this.updateProductVar(min, max);
        }
    }
}

