/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatEvent;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.FloatExpImpl;
import org.openl.ie.tools.Reusable;
import org.openl.ie.tools.ReusableFactory;

public final class FloatExpMultiplyPositive
extends FloatExpImpl {
    private FloatExp _exp;
    private double _value;
    private ExpressionObserver _observer;

    public FloatExpMultiplyPositive(FloatExp exp, double value) {
        super(exp.constrainer(), "");
        if (value <= 0.0) {
            this.abort("negative value in FloatExpMultiplyPositive");
        }
        this._exp = exp;
        this._value = value;
        this._observer = new FloatExpMultiplyPositiveObserver();
        this._exp.attachObserver(this._observer);
    }

    @Override
    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._exp.calcCoeffs(map, factor * this._value);
    }

    @Override
    public boolean isLinear() {
        return this._exp.isLinear();
    }

    @Override
    public double max() {
        return this._exp.max() * this._value;
    }

    @Override
    public double min() {
        return this._exp.min() * this._value;
    }

    @Override
    public FloatExp mul(double value) {
        return this._exp.mul(this._value * value);
    }

    @Override
    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    @Override
    public void setMax(double max) throws Failure {
        this._exp.setMax(max / this._value);
    }

    @Override
    public void setMin(double min) throws Failure {
        this._exp.setMin(min / this._value);
    }

    @Override
    public void setValue(double value) throws Failure {
        this._exp.setValue(value / this._value);
    }

    @Override
    public String toString() {
        this.domainToString();
        return this.name() + "(" + this._exp + "x" + this._value + this.domainToString() + ")";
    }

    class FloatExpMultiplyPositiveObserver
    extends ExpressionObserver {
        FloatExpMultiplyPositiveObserver() {
        }

        @Override
        public Object master() {
            return FloatExpMultiplyPositive.this;
        }

        @Override
        public String toString() {
            return "FloatExpMultiplyPositiveObserver: " + FloatExpMultiplyPositive.this._exp + "+" + FloatExpMultiplyPositive.this._value;
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            FloatEvent e = (FloatEvent)event;
            FloatEventMulPositiveValue ev = FloatEventMulPositiveValue.getEvent(e, FloatExpMultiplyPositive.this._value);
            FloatExpMultiplyPositive.this.notifyObservers(ev);
        }
    }

    static class FloatEventMulPositiveValue
    extends FloatEvent {
        static ReusableFactory _factory = new ReusableFactory(){

            @Override
            protected Reusable createNewElement() {
                return new FloatEventMulPositiveValue();
            }
        };
        private double _value;
        private FloatEvent _event;

        FloatEventMulPositiveValue() {
        }

        static FloatEventMulPositiveValue getEvent(FloatEvent event, double value) {
            FloatEventMulPositiveValue ev = (FloatEventMulPositiveValue)_factory.getElement();
            ev.init(event, value);
            return ev;
        }

        public void init(FloatEvent e, double value) {
            this._event = e;
            this._value = value;
        }

        @Override
        public double max() {
            return this._event.max() * this._value;
        }

        @Override
        public double min() {
            return this._event.min() * this._value;
        }

        @Override
        public String name() {
            return "FloatEventMulPositiveValue";
        }

        @Override
        public double oldmax() {
            return this._event.oldmax() * this._value;
        }

        @Override
        public double oldmin() {
            return this._event.oldmin() * this._value;
        }

        @Override
        public int type() {
            return this._event.type();
        }
    }
}

