/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.FloatVar;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.ExpressionObserver;
import org.openl.ie.constrainer.impl.FloatCalc;
import org.openl.ie.constrainer.impl.FloatExpImpl;

public final class FloatExpPowValue
extends FloatExpImpl {
    private static final int[] event_map = new int[]{6, 2, 6, 4, 1, 1, 8, 8};
    private FloatExp _exp;
    private double _value;
    private FloatVar _result;
    private ExpressionObserver _observer;

    public FloatExpPowValue(FloatExp exp, double value) {
        super(exp.constrainer(), "");
        this._exp = exp;
        this._value = value;
        this._observer = new FloatExpPowValueObserver();
        this._exp.attachObserver(this._observer);
        int trace = 0;
        this._result = this.constrainer().addFloatVarTraceInternal(this.calc_min(), this.calc_max(), "pow", trace);
    }

    @Override
    public void attachObserver(Observer observer) {
        super.attachObserver(observer);
        this._result.attachObserver(observer);
    }

    double calc_max() {
        return Math.pow(this._exp.max(), this._value);
    }

    double calc_min() {
        return Math.pow(this._exp.min(), this._value);
    }

    @Override
    public void detachObserver(Observer observer) {
        super.detachObserver(observer);
        this._result.detachObserver(observer);
    }

    @Override
    public double max() {
        return this._result.max();
    }

    @Override
    public double min() {
        return this._result.min();
    }

    @Override
    public void onMaskChange() {
        this._observer.publish(this.publisherMask(), this._exp);
    }

    @Override
    public void reattachObserver(Observer observer) {
        super.reattachObserver(observer);
        this._result.reattachObserver(observer);
    }

    @Override
    public void setMax(double max) throws Failure {
        if (max < 0.0) {
            this.constrainer().fail("max < 0");
        }
        double expMax = FloatCalc.solve_pow(max, this._value);
        this._exp.setMax(expMax);
    }

    @Override
    public void setMin(double min) throws Failure {
        if (min <= 0.0) {
            return;
        }
        double expMin = FloatCalc.solve_pow(min, this._value);
        this._exp.setMin(expMin);
    }

    @Override
    public void setValue(double value) throws Failure {
        if (value <= 0.0) {
            this.constrainer().fail("value <= 0");
        }
        double expV = FloatCalc.solve_pow(value, this._value);
        this._exp.setValue(expV);
    }

    @Override
    public String toString() {
        return "pow(" + this._exp + "," + this._value + ")" + this.domainToString();
    }

    class FloatExpPowValueObserver
    extends ExpressionObserver {
        FloatExpPowValueObserver() {
            super(event_map);
        }

        @Override
        public Object master() {
            return FloatExpPowValue.this;
        }

        @Override
        public String toString() {
            return "FloatExpPowValueObserver: pow(" + FloatExpPowValue.this._exp + "," + FloatExpPowValue.this._value + ")";
        }

        @Override
        public void update(Subject exp, EventOfInterest event) throws Failure {
            FloatExpPowValue.this._result.setMin(FloatExpPowValue.this.calc_min());
            FloatExpPowValue.this._result.setMax(FloatExpPowValue.this.calc_max());
        }
    }
}

