/*
 * Decompiled with CFR 0.152.
 */
package org.openl.ie.constrainer.impl;

import java.util.Map;
import org.openl.ie.constrainer.EventOfInterest;
import org.openl.ie.constrainer.Failure;
import org.openl.ie.constrainer.FloatExp;
import org.openl.ie.constrainer.NonLinearExpression;
import org.openl.ie.constrainer.Observer;
import org.openl.ie.constrainer.Subject;
import org.openl.ie.constrainer.impl.FloatCalc;
import org.openl.ie.constrainer.impl.IntBoolExpForSubject;

public class IntBoolExpFloatEqExp
extends IntBoolExpForSubject {
    protected FloatExp _exp1;
    protected FloatExp _exp2;
    protected double _offset;
    private Observer _observer;

    public IntBoolExpFloatEqExp(FloatExp exp1, FloatExp exp2) {
        this(exp1, exp2, 0.0);
    }

    public IntBoolExpFloatEqExp(FloatExp exp1, FloatExp exp2, double offset) {
        super(exp1.constrainer());
        this._exp1 = exp1;
        this._exp2 = exp2;
        this._offset = offset;
        if (this.constrainer().showInternalNames()) {
            this._name = offset == 0.0 ? "(" + exp1.name() + "==" + exp2.name() + ")" : (offset > 0.0 ? "(" + exp1.name() + "==" + exp2.name() + "+" + offset + ")" : "(" + exp1.name() + "==" + exp2.name() + offset + ")");
        }
        this.setDomainMinMaxSafe();
        this._observer = new ObserverMinMax();
        this._exp1.attachObserver(this._observer);
        this._exp2.attachObserver(this._observer);
    }

    @Override
    public double calcCoeffs(Map map, double factor) throws NonLinearExpression {
        return this._exp2.sub(this._exp1).add(this._offset).calcCoeffs(map, factor);
    }

    @Override
    public boolean isLinear() {
        return this._exp1.isLinear() && this._exp2.isLinear();
    }

    @Override
    protected boolean isSubjectFalse() {
        return FloatCalc.gt(this._exp1.min(), this._exp2.max() + this._offset) || FloatCalc.gt(this._exp2.min() + this._offset, this._exp1.max());
    }

    @Override
    protected boolean isSubjectTrue() {
        try {
            return this._exp1.bound() && this._exp2.bound() && FloatCalc.eq(this._exp1.value(), this._exp2.value() + this._offset);
        }
        catch (Failure e) {
            return false;
        }
    }

    @Override
    protected void setSubjectFalse() throws Failure {
    }

    @Override
    protected void setSubjectTrue() throws Failure {
        this._exp1.setMax(this._exp2.max() + this._offset);
        this._exp2.setMax(this._exp1.max() - this._offset);
        this._exp1.setMin(this._exp2.min() + this._offset);
        this._exp2.setMin(this._exp1.min() - this._offset);
    }

    final class ObserverMinMax
    extends Observer {
        ObserverMinMax() {
        }

        @Override
        public Object master() {
            return IntBoolExpFloatEqExp.this;
        }

        @Override
        public int subscriberMask() {
            return 6;
        }

        @Override
        public void update(Subject exp, EventOfInterest interest) throws Failure {
            IntBoolExpFloatEqExp.this.setDomainMinMax();
        }
    }
}

